/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.lang.html.HTML;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.Dom;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Nodes;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.ContentType;
import com.google.caja.util.Pipeline;
import com.google.caja.util.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ListIterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolveUriStage
implements Pipeline.Stage<Jobs> {
    private static final ElKey BASE = ElKey.forHtmlElement("base");
    private static final AttribKey BASE_HREF = AttribKey.forHtmlAttrib(BASE, "href");
    private final HtmlSchema schema;

    public ResolveUriStage(HtmlSchema schema) {
        this.schema = schema;
    }

    private static boolean isBaseUri(URI uri) {
        return uri != null && uri.isAbsolute() && !uri.isOpaque() && !Strings.equalsIgnoreCase("unknown", uri.getScheme());
    }

    private URI baseUri(Node root, URI uri, FilePosition pos) {
        URI baseUri = this.baseUriForDoc(root);
        if (!(ResolveUriStage.isBaseUri(baseUri) || ResolveUriStage.isBaseUri(baseUri = uri) || ResolveUriStage.isBaseUri(baseUri = pos.source().getUri()))) {
            return null;
        }
        return baseUri;
    }

    private URI baseUriForDoc(Node root) {
        if (root instanceof Element) {
            Element el = (Element)root;
            if (BASE.is((Element)root)) {
                return this.uriFromBaseElement(el);
            }
            for (Element base : Nodes.nodeListIterable(el.getElementsByTagNameNS(ResolveUriStage.BASE.ns.uri, ResolveUriStage.BASE.localName), Element.class)) {
                URI uri = this.uriFromBaseElement(base);
                if (uri == null) continue;
                return uri;
            }
            return null;
        }
        for (Node node : Nodes.childrenOf(root)) {
            URI uri = this.baseUriForDoc(node);
            if (uri == null) continue;
            return uri;
        }
        return null;
    }

    private URI uriFromBaseElement(Element base) {
        Attr a = base.getAttributeNodeNS(ResolveUriStage.BASE_HREF.ns.uri, ResolveUriStage.BASE_HREF.localName);
        if (a == null) {
            return null;
        }
        String value = a.getValue();
        try {
            URI uri = new URI(value);
            return ResolveUriStage.isBaseUri(uri) ? uri : null;
        }
        catch (URISyntaxException ex) {
            return null;
        }
    }

    @Override
    public boolean apply(Jobs jobs) {
        MessageQueue mq = jobs.getMessageQueue();
        ListIterator<Job> it = jobs.getJobs().listIterator();
        while (it.hasNext()) {
            Job job = it.next();
            if (job.getType() != ContentType.HTML) continue;
            Dom dom = (Dom)job.getRoot();
            Node node = dom.getValue();
            URI baseUri = this.baseUri(node, job.getBaseUri(), dom.getFilePosition());
            if (baseUri != null) {
                try {
                    baseUri = URI.create(UriUtil.normalizeUri(baseUri.toString()));
                }
                catch (URISyntaxException ex) {
                    mq.addMessage((MessageTypeInt)PluginMessageType.MALFORMED_URL, dom.getFilePosition(), MessagePart.Factory.valueOf(baseUri.toString()));
                    baseUri = null;
                }
            }
            if (baseUri == null) continue;
            this.resolveRelativeUrls(node, baseUri, mq);
            it.set(Job.domJob(job.getCacheKeys(), dom, baseUri));
        }
        return true;
    }

    private void resolveRelativeUrls(Node n, URI base, MessageQueue mq) {
        if (n instanceof Element) {
            Element el = (Element)n;
            ElKey elKey = ElKey.forElement(el);
            for (Attr attr : Nodes.attributesOf(el)) {
                String value;
                HTML.Attribute attrInfo;
                AttribKey aKey = AttribKey.forAttribute(elKey, attr);
                if (BASE_HREF.equals(aKey) || (attrInfo = this.schema.lookupAttribute(aKey)) == null || attrInfo.getType() != HTML.Attribute.Type.URI || (value = attr.getValue()).startsWith("#")) continue;
                URI uri = null;
                try {
                    uri = UriUtil.resolve(base, value);
                }
                catch (URISyntaxException ex) {
                    mq.addMessage((MessageTypeInt)PluginMessageType.MALFORMED_URL, Nodes.getFilePositionForValue(attr), MessagePart.Factory.valueOf(value));
                }
                if (uri == null || !uri.isAbsolute()) continue;
                FilePosition valuePos = Nodes.getFilePositionForValue(attr);
                attr.setValue(base.resolve(uri).toString());
                Nodes.setFilePositionForValue(attr, valuePos);
            }
        }
        for (Node c = n.getFirstChild(); c != null; c = c.getNextSibling()) {
            this.resolveRelativeUrls(c, base, mq);
        }
    }
}

