/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.Parser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultParser
extends CompositeParser {
    private static final long serialVersionUID = 3612324825403757520L;

    private static List<Parser> getDefaultParsers(ServiceLoader loader) {
        List<Parser> svcParsers = loader.loadServiceProviders(Parser.class);
        ArrayList<Parser> parsers = new ArrayList<Parser>(svcParsers.size());
        Collections.sort(svcParsers, new Comparator<Parser>(){

            @Override
            public int compare(Parser p1, Parser p2) {
                return p1.getClass().getName().compareTo(p2.getClass().getName());
            }
        });
        for (Parser p : svcParsers) {
            if (!p.getClass().getName().startsWith("org.apache.tika")) continue;
            parsers.add(p);
        }
        for (Parser p : svcParsers) {
            if (p.getClass().getName().startsWith("org.apache.tika")) continue;
            parsers.add(p);
        }
        return parsers;
    }

    public DefaultParser(MediaTypeRegistry registry, ServiceLoader loader) {
        super(registry, DefaultParser.getDefaultParsers(loader));
    }

    public DefaultParser(MediaTypeRegistry registry, ClassLoader loader) {
        this(registry, new ServiceLoader(loader));
    }

    public DefaultParser(ClassLoader loader) {
        this(MediaTypeRegistry.getDefaultRegistry(), new ServiceLoader(loader));
    }

    public DefaultParser(MediaTypeRegistry registry) {
        this(registry, new ServiceLoader());
    }

    public DefaultParser() {
        this(MediaTypeRegistry.getDefaultRegistry());
    }
}

