/*
 * Decompiled with CFR 0.152.
 */
package juzu.impl.fs.spi.composite;

import java.io.IOException;
import java.util.Iterator;
import juzu.impl.common.AbstractTrie;
import juzu.impl.fs.spi.PathType;
import juzu.impl.fs.spi.ReadFileSystem;
import juzu.impl.fs.spi.composite.CompositeFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Context
extends AbstractTrie<String, Context> {
    final CompositeFileSystem fs;
    boolean resolved;
    final Object[] paths;

    Context(CompositeFileSystem fs) {
        this.fs = fs;
        this.resolved = false;
        this.paths = new Object[fs.compounds.length];
    }

    private Context(Context parent, String key) {
        super(parent, key);
        this.fs = parent.fs;
        this.resolved = false;
        this.paths = new Object[parent.paths.length];
    }

    @Override
    protected Context create(Context parent, String key) {
        return new Context(parent, key);
    }

    Context resolve() throws IOException {
        if (!this.resolved) {
            int i;
            Context parent = (Context)this.getParent();
            if (parent == null) {
                for (i = 0; i < this.paths.length; ++i) {
                    this.paths[i] = this.fs.compounds[i].getRoot();
                }
            }
            for (i = 0; i < this.paths.length; ++i) {
                ReadFileSystem<?> compound;
                Object path = this.paths[i];
                if (path == null || (compound = this.fs.compounds[i]).typeOf(path) != PathType.DIR) continue;
                Iterator<Object> children = compound.getChildren(path);
                while (children.hasNext()) {
                    Object child = children.next();
                    String name = compound.getName(child);
                    ((Context)this.add(name)).paths[i] = child;
                }
            }
            this.resolved = true;
        }
        return this;
    }
}

