/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.common.webui;

import org.exoplatform.forum.common.webui.UIPopupContainer;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class)
public abstract class AbstractPopupAction
extends UIContainer {
    public AbstractPopupAction() throws Exception {
        UIPopupWindow popupWindow = (UIPopupWindow)((UIPopupWindow)this.createUIComponent(UIPopupWindow.class, null, null)).setRendered(false);
        popupWindow.setResizable(true);
        this.addChild((UIComponent)popupWindow);
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        context.getWriter().append("<span class=\"").append(this.getId()).append(" UIKSPopupAction\" id=\"").append(this.getId()).append("\">");
        this.renderChildren(context);
        context.getWriter().append("</span>");
        this.afterProcessRender(context);
    }

    protected abstract void afterProcessRender(WebuiRequestContext var1);

    public <T extends UIComponent> T activate(Class<T> type, int width) throws Exception {
        return this.activate(type, null, width, 0);
    }

    public <T extends UIComponent> T activate(Class<T> type, String configId, int width, int height) throws Exception {
        UIComponent comp = this.createUIComponent(type, configId, null);
        this.activate(comp, width, height);
        return (T)comp;
    }

    public void activate(UIComponent uiComponent, int width, int height) throws Exception {
        this.activate(uiComponent, width, height, true);
    }

    public void activate(UIComponent uiComponent, int width, int height, boolean isResizeable) throws Exception {
        UIPopupWindow popup = (UIPopupWindow)this.getChild(UIPopupWindow.class);
        popup.setUIComponent(uiComponent);
        ((UIPopupComponent)uiComponent).activate();
        popup.setWindowSize(width, height);
        popup.setRendered(true);
        popup.setShow(true);
        popup.setResizable(isResizeable);
    }

    public void deActivate() throws Exception {
        UIPopupWindow popup = (UIPopupWindow)this.getChild(UIPopupWindow.class);
        if (popup.getUIComponent() != null) {
            ((UIPopupComponent)popup.getUIComponent()).deActivate();
        }
        popup.setUIComponent(null);
        popup.setRendered(false);
    }

    public void cancelPopupAction() throws Exception {
        this.deActivate();
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        context.addUIComponentToUpdateByAjax((UIComponent)this);
    }

    public final UIPopupContainer prepareForNewForm() throws Exception {
        UIPopupContainer popupContainer = (UIPopupContainer)this.createUIComponent(UIPopupContainer.class, null, null);
        String id = "UIPopup";
        UIComponent parent = this.getParent();
        if (parent != null && parent.getId() != null && (!(id = this.getParent().getId()).contains("Portlet") || id.contains("Container"))) {
            id = ((UIPortletApplication)this.getAncestorOfType(UIPortletApplication.class)).getId().replaceFirst("Portlet", "");
            this.setId(id + "ChildPopupAction");
            ((UIPopupWindow)this.getChild(UIPopupWindow.class)).setId(id + "ChildPopupWindow");
        }
        AbstractPopupAction childPopupAction = (AbstractPopupAction)((AbstractPopupAction)popupContainer.addChild(((Object)((Object)this)).getClass(), null, this.getName() + "ChildPopupAction")).setRendered(true);
        ((UIPopupWindow)childPopupAction.getChild(UIPopupWindow.class)).setId(this.getName() + "ChildPopupWindow");
        return popupContainer;
    }
}

