/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.BitSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.CommittableIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.SharedIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractIndex {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.AbstractIndex");
    private static final LoggingPrintStream STREAM_LOGGER = new LoggingPrintStream();
    private IndexWriter indexWriter;
    private CommittableIndexReader indexReader;
    private Directory directory;
    private Analyzer analyzer;
    private final Similarity similarity;
    private boolean useCompoundFile = true;
    private int maxFieldLength = 10000;
    private int termInfosIndexDivisor = 1;
    private DocNumberCache cache;
    private SharedIndexReader sharedReader;
    private ReadOnlyIndexReader readOnlyReader;
    private boolean isExisting;
    protected final IndexerIoModeHandler modeHandler;

    AbstractIndex(Analyzer analyzer, Similarity similarity, Directory directory, DocNumberCache cache, IndexerIoModeHandler modeHandler) throws IOException {
        this.analyzer = analyzer;
        this.similarity = similarity;
        this.directory = directory;
        this.cache = cache;
        this.modeHandler = modeHandler;
        this.isExisting = IndexReader.indexExists((Directory)directory);
        if (!this.isExisting) {
            IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_30, analyzer);
            this.indexWriter = new IndexWriter(directory, config);
            this.indexWriter.close();
            this.indexWriter = null;
        }
    }

    Directory getDirectory() {
        return this.directory;
    }

    boolean isExisting() {
        return this.isExisting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDocuments(Document[] docs) throws IOException {
        IndexWriter writer = this.getIndexWriter();
        IOException ioExc = null;
        try {
            for (Document doc : docs) {
                try {
                    writer.addDocument(doc);
                }
                catch (Throwable e) {
                    if (ioExc == null) {
                        ioExc = e instanceof IOException ? (IOException)e : Util.createIOException(e);
                    }
                    log.warn("Exception while inverting document", e);
                }
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.invalidateSharedReader();
            throw throwable;
        }
        this.invalidateSharedReader();
        if (ioExc != null) {
            throw ioExc;
        }
    }

    int removeDocument(Term idTerm) throws IOException {
        return this.getIndexReader().deleteDocuments(idTerm);
    }

    protected synchronized CommittableIndexReader getIndexReader() throws IOException {
        if (this.indexWriter != null) {
            this.indexWriter.close();
            log.debug("closing IndexWriter.");
            this.indexWriter = null;
        }
        if (this.indexReader == null || !this.indexReader.isCurrent()) {
            IndexReader reader = IndexReader.open((Directory)this.getDirectory(), null, (boolean)false, (int)this.termInfosIndexDivisor);
            this.indexReader = new CommittableIndexReader(reader, this.modeHandler != null && this.modeHandler.getMode() == IndexerIoMode.READ_ONLY);
        }
        return this.indexReader;
    }

    synchronized ReadOnlyIndexReader getReadOnlyIndexReader(boolean initCache) throws IOException {
        CommittableIndexReader modifiableReader = this.getIndexReader();
        long modCount = modifiableReader.getModificationCount();
        if (this.readOnlyReader != null) {
            if (this.readOnlyReader.getDeletedDocsVersion() == modCount) {
                this.readOnlyReader.acquire();
                return this.readOnlyReader;
            }
            if (this.readOnlyReader.getRefCount() == 1) {
                this.readOnlyReader.updateDeletedDocs(modifiableReader);
                this.readOnlyReader.acquire();
                return this.readOnlyReader;
            }
            this.readOnlyReader.release();
            this.readOnlyReader = null;
        }
        BitSet deleted = new BitSet(modifiableReader.maxDoc());
        for (int i = 0; i < modifiableReader.maxDoc(); ++i) {
            if (!modifiableReader.isDeleted(i)) continue;
            deleted.set(i);
        }
        if (this.sharedReader == null) {
            IndexReader reader = IndexReader.open((Directory)this.getDirectory(), null, (boolean)true, (int)this.termInfosIndexDivisor);
            CachingIndexReader cr = new CachingIndexReader(reader, this.cache, initCache);
            this.sharedReader = new SharedIndexReader(cr);
        }
        this.readOnlyReader = new ReadOnlyIndexReader(this.sharedReader, deleted, modCount);
        this.readOnlyReader.acquire();
        return this.readOnlyReader;
    }

    protected ReadOnlyIndexReader getReadOnlyIndexReader() throws IOException {
        return this.getReadOnlyIndexReader(false);
    }

    protected synchronized IndexWriter getIndexWriter() throws IOException {
        if (this.indexReader != null) {
            this.indexReader.close();
            log.debug("closing IndexReader.");
            this.indexReader = null;
        }
        if (this.indexWriter == null) {
            IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_30, this.analyzer);
            config.setSimilarity(this.similarity);
            if (config.getMergePolicy() instanceof LogMergePolicy) {
                ((LogMergePolicy)config.getMergePolicy()).setUseCompoundFile(this.useCompoundFile);
            } else {
                log.error("Can't set \"UseCompoundFile\". Merge policy is not an instance of LogMergePolicy. ");
            }
            this.indexWriter = new IndexWriter(this.directory, config);
            this.setUseCompoundFile(this.useCompoundFile);
            this.indexWriter.setInfoStream((PrintStream)STREAM_LOGGER);
        }
        return this.indexWriter;
    }

    protected void commit() throws IOException {
        this.commit(false);
    }

    protected synchronized void commit(boolean optimize) throws IOException {
        if (this.indexReader != null) {
            log.debug("committing IndexReader.");
            this.indexReader.flush();
        }
        if (this.indexWriter != null) {
            log.debug("committing IndexWriter.");
            this.indexWriter.commit();
        }
        if (optimize) {
            IndexWriter writer = this.getIndexWriter();
            writer.optimize();
            writer.close();
            this.indexWriter = null;
        }
    }

    synchronized void close() {
        this.releaseWriterAndReaders();
        if (this.directory != null) {
            try {
                this.directory.close();
            }
            catch (IOException e) {
                this.directory = null;
            }
        }
    }

    protected void releaseWriterAndReaders() {
        if (this.indexWriter != null) {
            try {
                this.indexWriter.close();
            }
            catch (IOException e) {
                log.warn("Exception closing index writer: " + e.toString());
            }
            this.indexWriter = null;
        }
        if (this.indexReader != null) {
            try {
                this.indexReader.close();
            }
            catch (IOException e) {
                log.warn("Exception closing index reader: " + e.toString());
            }
            this.indexReader = null;
        }
        if (this.readOnlyReader != null) {
            try {
                this.readOnlyReader.release();
            }
            catch (IOException e) {
                log.warn("Exception closing index reader: " + e.toString());
            }
            this.readOnlyReader = null;
        }
        if (this.sharedReader != null) {
            try {
                this.sharedReader.release();
            }
            catch (IOException e) {
                log.warn("Exception closing index reader: " + e.toString());
            }
            this.sharedReader = null;
        }
    }

    synchronized long getRamSizeInBytes() {
        if (this.indexWriter != null) {
            return this.indexWriter.ramSizeInBytes();
        }
        return 0L;
    }

    protected synchronized void invalidateSharedReader() throws IOException {
        if (this.readOnlyReader != null) {
            this.readOnlyReader.release();
            this.readOnlyReader = null;
        }
        if (this.sharedReader != null) {
            this.sharedReader.release();
            this.sharedReader = null;
        }
    }

    void setUseCompoundFile(boolean b) {
        this.useCompoundFile = b;
        if (this.indexWriter != null) {
            IndexWriterConfig config = this.indexWriter.getConfig();
            if (config.getMergePolicy() instanceof LogMergePolicy) {
                ((LogMergePolicy)config.getMergePolicy()).setUseCompoundFile(this.useCompoundFile);
                ((LogMergePolicy)config.getMergePolicy()).setNoCFSRatio(1.0);
            } else {
                log.error("Can't set \"UseCompoundFile\". Merge policy is not an instance of LogMergePolicy. ");
            }
        }
    }

    void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
        if (this.indexWriter != null) {
            this.indexWriter.setMaxFieldLength(this.maxFieldLength);
        }
    }

    public int getTermInfosIndexDivisor() {
        return this.termInfosIndexDivisor;
    }

    public void setTermInfosIndexDivisor(int termInfosIndexDivisor) {
        this.termInfosIndexDivisor = termInfosIndexDivisor;
    }

    private static final class LoggingPrintStream
    extends PrintStream {
        private StringBuffer buffer = new StringBuffer();

        public LoggingPrintStream() {
            super(new OutputStream(){

                public void write(int b) {
                }
            });
        }

        public void print(String s) {
            this.buffer.append(s);
        }

        public void println(String s) {
            this.buffer.append(s);
            log.debug(this.buffer.toString());
            this.buffer.setLength(0);
        }
    }
}

