/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.controller.router;

import java.util.List;
import org.exoplatform.web.controller.router.PathParam;
import org.exoplatform.web.controller.router.PercentEncoding;
import org.exoplatform.web.controller.router.Regex;
import org.exoplatform.web.controller.router.Route;
import org.exoplatform.web.controller.router.Router;

class PatternRoute
extends Route {
    final Regex pattern;
    final PathParam[] params;
    final String[] chunks;
    final String[] encodedChunks;

    PatternRoute(Router router, Regex pattern, List<PathParam> params, List<String> chunks) {
        super(router);
        if (chunks.size() != params.size() + 1) {
            throw new AssertionError((Object)("Was expecting chunk size " + chunks.size() + " to be equals to " + params.size() + 1));
        }
        String[] encodedChunks = new String[chunks.size()];
        for (int i = 0; i < chunks.size(); ++i) {
            encodedChunks[i] = PercentEncoding.PATH_SEGMENT.encode(chunks.get(i));
        }
        this.pattern = pattern;
        this.params = params.toArray(new PathParam[params.size()]);
        this.chunks = chunks.toArray(new String[chunks.size()]);
        this.encodedChunks = encodedChunks;
    }
}

