/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.xml.stax.writer;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.gatein.common.xml.stax.writer.WritableValueType;
import org.gatein.common.xml.stax.writer.WritableValueTypes;
import org.gatein.common.xml.stax.writer.formatting.NoOpFormatter;
import org.gatein.common.xml.stax.writer.formatting.XmlStreamingFormatter;
import org.staxnav.Naming;
import org.staxnav.StaxNavException;

public class StaxWriterImpl<N>
implements StaxWriter<N>,
XMLStreamConstants {
    private Naming<N> naming;
    private XMLStreamWriter writer;
    private XmlStreamingFormatter formatter;
    private Deque<Element> elementStack = new ArrayDeque<Element>();

    public StaxWriterImpl(Naming<N> naming, XMLStreamWriter writer) {
        this(naming, writer, null);
    }

    public StaxWriterImpl(Naming<N> naming, XMLStreamWriter writer, XmlStreamingFormatter formatter) {
        this(naming, writer, formatter, null, null);
    }

    public StaxWriterImpl(Naming<N> naming, XMLStreamWriter writer, XmlStreamingFormatter formatter, String encoding, String version) {
        this.naming = naming;
        this.writer = writer;
        if (formatter == null) {
            formatter = new NoOpFormatter();
        }
        this.formatter = formatter;
        this.elementStack.push(new RootElement(writer, formatter, encoding, version));
    }

    @Override
    public StaxWriter<N> writeAttribute(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        Element current = this.elementStack.peek();
        current.writeAttribute(name, value);
        return this;
    }

    @Override
    public StaxWriter<N> writeAttribute(QName name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        Element current = this.elementStack.peek();
        current.writeAttribute(name, value);
        return this;
    }

    @Override
    public StaxWriter<N> writeStartElement(N element) throws StaxNavException {
        Element current = this.elementStack.peek();
        if (current instanceof RootElement) {
            if (((RootElement)current).started) {
                current = new StreamElement(this.writer, this.formatter);
                this.elementStack.push(current);
            }
        } else {
            current = new StreamElement(this.writer, this.formatter);
            this.elementStack.push(current);
        }
        current.writeStartElement(this.naming, element);
        return this;
    }

    @Override
    public StaxWriter<N> writeEndElement() throws StaxNavException {
        if (this.elementStack.isEmpty()) {
            throw new StaxNavException(null, "No matching startElement was found for this endElement");
        }
        this.elementStack.pop().end();
        return this;
    }

    @Override
    public StaxWriter<N> writeContent(String content) throws StaxNavException {
        return this.writeContent(WritableValueTypes.STRING, content);
    }

    @Override
    public <V> StaxWriter<N> writeContent(WritableValueType<V> valueType, V content) throws StaxNavException {
        if (valueType == null) {
            throw new IllegalArgumentException("valueType cannot be null.");
        }
        if (content == null) {
            throw new IllegalArgumentException("content cannot be null.");
        }
        Element current = this.elementStack.peek();
        current.writeContent(valueType.format(content));
        return this;
    }

    @Override
    public <V> StaxWriter<N> writeElement(N element, String content) throws StaxNavException {
        return this.writeElement(element, WritableValueTypes.STRING, content);
    }

    @Override
    public <V> StaxWriter<N> writeElement(N element, WritableValueType<V> valueType, V content) throws StaxNavException {
        this.writeStartElement(element).writeContent(valueType, content).writeEndElement();
        return this;
    }

    @Override
    public StaxWriter<N> writeNamespace(String prefix, String uri) throws StaxNavException {
        Element current = this.elementStack.peek();
        current.writeNamespace(prefix, uri);
        return this;
    }

    @Override
    public StaxWriter<N> writeDefaultNamespace(String uri) throws StaxNavException {
        Element current = this.elementStack.peek();
        current.writeDefaultNamespace(uri);
        return this;
    }

    @Override
    public StaxWriter<N> writeComment(String comment) throws StaxNavException {
        Element current = this.elementStack.peek();
        current.writeComment(comment);
        return this;
    }

    @Override
    public StaxWriter<N> writeCData(String cdata) throws StaxNavException {
        Element current = this.elementStack.peek();
        current.writeCData(cdata);
        return this;
    }

    @Override
    public void finish() throws StaxNavException {
        while (!this.elementStack.isEmpty()) {
            this.elementStack.pop().end();
        }
    }

    private static interface StreamClosure {
        public void execute(XMLStreamWriter var1) throws XMLStreamException;
    }

    private static class StreamElement
    extends Element {
        StreamElement(XMLStreamWriter writer, XmlStreamingFormatter formatter) {
            super(writer, formatter);
        }

        @Override
        public void writeAttribute(final String name, final String value) throws StaxNavException {
            this.apply(10, new StreamClosure(){

                @Override
                public void execute(XMLStreamWriter writer) throws XMLStreamException {
                    writer.writeAttribute(name, value);
                }
            });
        }

        @Override
        public <N> void writeAttribute(QName name, final String value) throws StaxNavException {
            final String prefix = name.getPrefix();
            final String uri = name.getNamespaceURI();
            final String localPart = name.getLocalPart();
            this.apply(10, new StreamClosure(){

                @Override
                public void execute(XMLStreamWriter writer) throws XMLStreamException {
                    if (uri == null || "".equals(uri)) {
                        writer.writeAttribute(localPart, value);
                    } else if (prefix == null || "".equals(prefix)) {
                        writer.writeAttribute(uri, localPart, value);
                    } else {
                        writer.writeAttribute(prefix, uri, localPart, value);
                    }
                }
            });
        }

        @Override
        public <N> void writeStartElement(Naming<N> naming, N name) throws StaxNavException {
            final String prefix = naming.getPrefix(name);
            final String uri = naming.getURI(name);
            final String localPart = naming.getLocalPart(name);
            this.apply(1, new StreamClosure(){

                @Override
                public void execute(XMLStreamWriter writer) throws XMLStreamException {
                    if (uri == null || "".equals(uri)) {
                        writer.writeStartElement(localPart);
                    } else if (prefix == null || "".equals(prefix)) {
                        writer.writeStartElement(uri, localPart);
                    } else {
                        writer.writeStartElement(prefix, localPart, uri);
                    }
                }
            });
        }

        @Override
        public void writeContent(final String content) throws StaxNavException {
            this.apply(4, new StreamClosure(){

                @Override
                public void execute(XMLStreamWriter writer) throws XMLStreamException {
                    writer.writeCharacters(content);
                }
            });
        }

        @Override
        public void writeNamespace(final String prefix, final String uri) throws StaxNavException {
            this.apply(13, new StreamClosure(){

                @Override
                public void execute(XMLStreamWriter writer) throws XMLStreamException {
                    writer.writeNamespace(prefix, uri);
                }
            });
        }

        @Override
        public void writeDefaultNamespace(final String uri) throws StaxNavException {
            this.apply(13, new StreamClosure(){

                @Override
                public void execute(XMLStreamWriter writer) throws XMLStreamException {
                    writer.writeDefaultNamespace(uri);
                }
            });
        }

        @Override
        public void writeComment(final String comment) throws StaxNavException {
            this.apply(5, new StreamClosure(){

                @Override
                public void execute(XMLStreamWriter writer) throws XMLStreamException {
                    writer.writeComment(comment);
                }
            });
        }

        @Override
        public void writeCData(final String cdata) throws StaxNavException {
            this.apply(12, new StreamClosure(){

                @Override
                public void execute(XMLStreamWriter writer) throws XMLStreamException {
                    writer.writeCData(cdata);
                }
            });
        }

        @Override
        public void end() {
            this.apply(2, new StreamClosure(){

                @Override
                public void execute(XMLStreamWriter writer) throws XMLStreamException {
                    writer.writeEndElement();
                }
            });
        }
    }

    private static class RootElement
    extends Element {
        private String encoding;
        private String version;
        private Element element;
        private boolean started;

        RootElement(XMLStreamWriter writer, XmlStreamingFormatter formatter, String encoding, String version) {
            super(writer, formatter);
            this.encoding = encoding;
            this.version = version;
        }

        @Override
        public void writeAttribute(String name, String value) throws StaxNavException {
            this.get().writeAttribute(name, value);
        }

        @Override
        public <N> void writeAttribute(QName name, String value) throws StaxNavException {
            this.get().writeAttribute(name, value);
        }

        @Override
        public <N> void writeStartElement(Naming<N> naming, N name) throws StaxNavException {
            this.get().writeStartElement(naming, name);
            this.started = true;
        }

        @Override
        public void writeContent(String content) throws StaxNavException {
            this.get().writeContent(content);
        }

        @Override
        public void writeNamespace(String prefix, String uri) throws StaxNavException {
            this.get().writeNamespace(prefix, uri);
        }

        @Override
        public void writeDefaultNamespace(String uri) throws StaxNavException {
            this.get().writeDefaultNamespace(uri);
        }

        @Override
        public void writeComment(String comment) throws StaxNavException {
            this.get().writeComment(comment);
        }

        @Override
        public void writeCData(String cdata) throws StaxNavException {
            this.get().writeCData(cdata);
        }

        @Override
        public void end() {
            if (this.started) {
                this.get().end();
            }
            this.endDocument();
        }

        private Element get() {
            if (this.element == null) {
                this.startDocument();
                this.element = new StreamElement(this.writer, this.formatter);
            }
            return this.element;
        }

        private void startDocument() throws StaxNavException {
            this.apply(7, new StreamClosure(){

                @Override
                public void execute(XMLStreamWriter writer) throws XMLStreamException {
                    if (RootElement.this.encoding == null && RootElement.this.version == null) {
                        writer.writeStartDocument();
                    } else if (RootElement.this.encoding == null) {
                        writer.writeStartDocument(RootElement.this.version);
                    } else {
                        writer.writeStartDocument(RootElement.this.encoding, RootElement.this.version);
                    }
                }
            });
        }

        private void endDocument() throws StaxNavException {
            try {
                this.apply(8, new StreamClosure(){

                    @Override
                    public void execute(XMLStreamWriter writer) throws XMLStreamException {
                        writer.writeEndDocument();
                    }
                });
                this.writer.flush();
            }
            catch (XMLStreamException e) {
                throw new StaxNavException(e);
            }
            finally {
                try {
                    this.writer.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    private static abstract class Element {
        XMLStreamWriter writer;
        XmlStreamingFormatter formatter;
        private List<StreamClosure> closures;

        abstract void writeAttribute(String var1, String var2) throws StaxNavException;

        abstract <N> void writeAttribute(QName var1, String var2) throws StaxNavException;

        abstract <N> void writeStartElement(Naming<N> var1, N var2) throws StaxNavException;

        abstract void writeContent(String var1) throws StaxNavException;

        abstract void writeNamespace(String var1, String var2) throws StaxNavException;

        abstract void writeDefaultNamespace(String var1) throws StaxNavException;

        abstract void writeComment(String var1) throws StaxNavException;

        abstract void writeCData(String var1) throws StaxNavException;

        abstract void end();

        Element(XMLStreamWriter writer, XmlStreamingFormatter formatter) {
            this(writer, formatter, null);
        }

        Element(XMLStreamWriter writer, XmlStreamingFormatter formatter, List<StreamClosure> closures) {
            this.writer = writer;
            this.formatter = formatter;
            this.closures = closures;
        }

        void apply(int event, StreamClosure closure) throws StaxNavException {
            try {
                this.formatter.before(this.writer, event);
                closure.execute(this.writer);
                this.formatter.after(this.writer, event);
            }
            catch (XMLStreamException e) {
                throw new StaxNavException(e);
            }
        }
    }
}

