/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.jodconverter.impl;

import java.io.File;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.jodconverter.JodConverterService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class JodConverterServiceImpl
implements JodConverterService,
Startable {
    private OfficeManager officeManager;
    private OfficeDocumentConverter documentConverter;
    private boolean enable;
    private static final Log LOG = ExoLogger.getLogger((String)JodConverterServiceImpl.class.getName());

    public JodConverterServiceImpl(InitParams initParams) throws Exception {
        block28: {
            this.officeManager = null;
            this.documentConverter = null;
            this.enable = false;
            String enableJod = System.getProperty("wcm.jodconverter.enable");
            this.enable = enableJod == null || enableJod.isEmpty() ? true : Boolean.parseBoolean(enableJod);
            if (this.enable) {
                DefaultOfficeManagerConfiguration configuration;
                block27: {
                    String maxTasksPerProcess;
                    block26: {
                        String retryTimeout;
                        block25: {
                            String taskExecutionTimeout;
                            block24: {
                                String taskQueueTimeout;
                                block23: {
                                    String officeHomeParam;
                                    block22: {
                                        officeHomeParam = initParams.getValueParam("officeHome").getValue();
                                        String portNumbers = initParams.getValueParam("port").getValue();
                                        taskQueueTimeout = initParams.getValueParam("taskQueueTimeout").getValue();
                                        taskExecutionTimeout = initParams.getValueParam("taskExecutionTimeout").getValue();
                                        maxTasksPerProcess = initParams.getValueParam("maxTasksPerProcess").getValue();
                                        retryTimeout = initParams.getValueParam("retryTimeout").getValue();
                                        configuration = new DefaultOfficeManagerConfiguration();
                                        if (portNumbers != null) {
                                            try {
                                                String[] portsList = portNumbers.split(",");
                                                int[] ports = new int[portsList.length];
                                                for (int i = 0; i < portsList.length; ++i) {
                                                    ports[i] = Integer.parseInt(portsList[i].trim());
                                                }
                                                configuration.setPortNumbers(ports);
                                            }
                                            catch (NumberFormatException nfe) {
                                                if (!LOG.isWarnEnabled()) break block22;
                                                LOG.warn((Object)"Wrong configuration ==> Use default portNumbers value of DefaultOfficeManagerConfiguration");
                                            }
                                        }
                                    }
                                    if (officeHomeParam != null && officeHomeParam.trim().length() != 0) {
                                        try {
                                            configuration.setOfficeHome(officeHomeParam);
                                        }
                                        catch (IllegalArgumentException iae) {
                                            if (!LOG.isWarnEnabled()) break block23;
                                            LOG.warn((Object)"Wrong configuration ==> Use default officeHome value of DefaultOfficeManagerConfiguration");
                                        }
                                    }
                                }
                                if (taskQueueTimeout != null) {
                                    try {
                                        configuration.setTaskQueueTimeout(Long.parseLong(taskQueueTimeout));
                                    }
                                    catch (NumberFormatException nfe) {
                                        if (!LOG.isWarnEnabled()) break block24;
                                        LOG.warn((Object)"Wrong configuration ==> Use default taskQueueTimeout value of DefaultOfficeManagerConfiguration");
                                    }
                                }
                            }
                            if (taskExecutionTimeout != null) {
                                try {
                                    configuration.setTaskExecutionTimeout(Long.parseLong(taskExecutionTimeout));
                                }
                                catch (NumberFormatException nfe) {
                                    if (!LOG.isWarnEnabled()) break block25;
                                    LOG.warn((Object)"Wrong configuration ==> Use default taskExecutionTimeout value of DefaultOfficeManagerConfiguration");
                                }
                            }
                        }
                        if (retryTimeout != null) {
                            try {
                                configuration.setRetryTimeout(Long.parseLong(retryTimeout));
                            }
                            catch (NumberFormatException nfe) {
                                if (!LOG.isWarnEnabled()) break block26;
                                LOG.warn((Object)"Wrong configuration ==> Use default retryTimeout value of DefaultOfficeManagerConfiguration");
                            }
                        }
                    }
                    if (maxTasksPerProcess != null) {
                        try {
                            configuration.setMaxTasksPerProcess(Integer.parseInt(maxTasksPerProcess));
                        }
                        catch (NumberFormatException nfe) {
                            if (!LOG.isWarnEnabled()) break block27;
                            LOG.warn((Object)"Wrong configuration ==> Use default maxTasksPerProcess value of DefaultOfficeManagerConfiguration");
                        }
                    }
                }
                try {
                    this.officeManager = configuration.buildOfficeManager();
                    this.documentConverter = new OfficeDocumentConverter(this.officeManager);
                }
                catch (IllegalStateException ise) {
                    if (!LOG.isErrorEnabled()) break block28;
                    LOG.equals(ise.getMessage());
                }
            }
        }
    }

    public void start() {
        block4: {
            if (!this.enable && LOG.isWarnEnabled()) {
                LOG.warn((Object)"JodConverter is disabled! To use JodConverter please change wcm.jodconverter.enable=true in configuration.properties file");
                return;
            }
            try {
                if (this.officeManager != null) {
                    this.officeManager.start();
                }
            }
            catch (OfficeException oe) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"Exception when start Office Service");
            }
        }
    }

    public void stop() {
        block4: {
            if (!this.enable && LOG.isWarnEnabled()) {
                LOG.warn((Object)"JodConverter is disabled! To use JodConverter please change wcm.jodconverter.enable=true in configuration.properties file");
                return;
            }
            try {
                if (this.officeManager != null) {
                    this.officeManager.stop();
                }
            }
            catch (OfficeException oe) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)"Exception when stop Office Service");
            }
        }
    }

    @Override
    public boolean convert(File input, File output, String outputFormat) throws OfficeException {
        if (!this.enable && LOG.isWarnEnabled()) {
            LOG.warn((Object)"JodConverter is disabled so you cannot view this document! To enable it, please change wcm.jodconverter.enable=true in configuration.properties file");
            return false;
        }
        if (this.officeManager != null && this.officeManager.isRunning()) {
            if (this.documentConverter != null) {
                this.documentConverter.convert(input, output, this.documentConverter.getFormatRegistry().getFormatByExtension(outputFormat));
                return true;
            }
            return false;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"this OfficeManager is currently stopped!");
        }
        return false;
    }
}

