/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.Set;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.ActivationInterceptor;
import org.infinispan.remoting.transport.Transport;

public class ClusteredActivationInterceptor
extends ActivationInterceptor {
    private Configuration.CacheMode cacheMode;
    private boolean isWriteSkewConfigured;
    private Transport transport;
    private DistributionManager distributionManager;

    @Inject
    private void injectClusteredActivationInterceptorDependencies(Transport transport, DistributionManager distributionManager) {
        this.transport = transport;
        this.distributionManager = distributionManager;
    }

    @Start(priority=15)
    private void startClusteredActivationInterceptor() {
        this.cacheMode = this.configuration.getCacheMode();
        this.isWriteSkewConfigured = this.configuration.isWriteSkewCheck() && this.cacheMode.isClustered();
    }

    @Override
    protected boolean forceLoad(Object key, Set<Flag> flags) {
        return this.isDeltaWrite(flags) || this.isWriteSkewConfigured && this.isPrimaryOwner(key);
    }

    private boolean isPrimaryOwner(Object key) {
        return this.cacheMode.isReplicated() && this.transport.isCoordinator() || this.cacheMode.isDistributed() && this.distributionManager.getPrimaryLocation(key).equals(this.transport.getAddress());
    }

    private boolean isDeltaWrite(Set<Flag> flags) {
        return flags != null && flags.contains((Object)Flag.DELTA_WRITE);
    }
}

