/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.juzu;

import javax.inject.Provider;
import juzu.inject.ProviderFactory;
import org.exoplatform.container.PortalContainer;

public class KernelProviderFactory
implements ProviderFactory {
    public <T> Provider<? extends T> getProvider(final Class<T> implementationType) throws Exception {
        final PortalContainer container = PortalContainer.getInstance();
        if (container == null) {
            throw new IllegalStateException("Not running in the context of a portal container");
        }
        return new Provider<T>(){

            public T get() {
                Object service = container.getComponentInstanceOfType(implementationType);
                if (service == null) {
                    throw new RuntimeException("Could not obtain service " + implementationType + " from container " + container);
                }
                return implementationType.cast(service);
            }
        };
    }
}

