/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.javascript.jscomp.AnonymousFunctionNamingPolicy;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.ComposeWarningsGuard;
import com.google.javascript.jscomp.CssRenamingMap;
import com.google.javascript.jscomp.CustomPassExecutionTime;
import com.google.javascript.jscomp.DiagnosticGroup;
import com.google.javascript.jscomp.DiagnosticGroupWarningsGuard;
import com.google.javascript.jscomp.ErrorFormat;
import com.google.javascript.jscomp.MessageBundle;
import com.google.javascript.jscomp.PropertyRenamingPolicy;
import com.google.javascript.jscomp.SourceMap;
import com.google.javascript.jscomp.VariableRenamingPolicy;
import com.google.javascript.jscomp.WarningsGuard;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.SourcePosition;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompilerOptions
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7L;
    private LanguageMode languageIn;
    private LanguageMode languageOut;
    boolean acceptConstKeyword = false;
    private boolean assumeStrictThis = false;
    public boolean ideMode;
    boolean inferTypes;
    boolean skipAllPasses = false;
    boolean nameAnonymousFunctionsOnly = false;
    DevMode devMode;
    boolean manageClosureDependencies = false;
    List<String> manageClosureDependenciesEntryPoints = ImmutableList.of();
    public transient MessageBundle messageBundle = null;
    public boolean checkSymbols = false;
    public CheckLevel checkShadowVars;
    public CheckLevel aggressiveVarCheck;
    public CheckLevel checkFunctions;
    public CheckLevel checkMethods;
    public boolean checkDuplicateMessages = false;
    public boolean allowLegacyJsMessages = false;
    public boolean strictMessageReplacement = false;
    public boolean checkSuspiciousCode = false;
    public boolean checkControlStructures = false;
    public boolean checkTypes = false;
    public boolean tightenTypes = false;
    public boolean checkTypedPropertyCalls = false;
    public CheckLevel reportMissingOverride;
    public CheckLevel reportUnknownTypes;
    public CheckLevel checkRequires;
    public CheckLevel checkProvides;
    public CheckLevel checkGlobalNamesLevel;
    public CheckLevel brokenClosureRequiresLevel;
    public CheckLevel checkGlobalThisLevel;
    public CheckLevel checkMissingGetCssNameLevel;
    public String checkMissingGetCssNameBlacklist = null;
    public boolean checkEs5Strict;
    public boolean checkCaja = false;
    Set<String> extraAnnotationNames = null;
    public boolean foldConstants = false;
    public boolean deadAssignmentElimination = false;
    public boolean inlineConstantVars = false;
    public boolean inlineFunctions = false;
    public boolean inlineLocalFunctions = false;
    public boolean assumeClosuresOnlyCaptureReferences = false;
    public boolean crossModuleCodeMotion = false;
    public boolean coalesceVariableNames = false;
    public boolean crossModuleMethodMotion = false;
    public boolean inlineGetters = false;
    public boolean inlineVariables = false;
    public boolean inlineLocalVariables = false;
    public boolean flowSensitiveInlineVariables;
    public boolean smartNameRemoval = false;
    public boolean removeDeadCode = false;
    public CheckLevel checkUnreachableCode;
    public CheckLevel checkMissingReturn;
    public boolean extractPrototypeMemberDeclarations = false;
    public boolean removeEmptyFunctions;
    public boolean removeUnusedPrototypeProperties = false;
    public boolean removeUnusedPrototypePropertiesInExterns = false;
    public boolean removeUnusedVars = false;
    public boolean removeUnusedLocalVars = false;
    public boolean aliasExternals = false;
    public String aliasableGlobals;
    public String unaliasableGlobals;
    public boolean collapseVariableDeclarations = false;
    public boolean groupVariableDeclarations = false;
    public boolean collapseAnonymousFunctions = false;
    public Set<String> aliasableStrings;
    public String aliasStringsBlacklist = "";
    public boolean aliasAllStrings = false;
    boolean outputJsStringUsage = false;
    public boolean convertToDottedProperties = false;
    public boolean rewriteFunctionExpressions = false;
    public boolean optimizeParameters = false;
    public boolean optimizeReturns = false;
    public boolean optimizeCalls;
    public boolean optimizeArgumentsArray;
    boolean chainCalls = false;
    public VariableRenamingPolicy variableRenaming;
    public PropertyRenamingPolicy propertyRenaming;
    boolean propertyAffinity = false;
    public boolean labelRenaming = false;
    public boolean reserveRawExports;
    boolean shadowVariables = false;
    public boolean generatePseudoNames = false;
    public String renamePrefix = null;
    public String renamePrefixNamespace;
    public boolean aliasKeywords = false;
    public boolean collapseProperties = false;
    public boolean collapseObjectLiterals = false;
    boolean collapsePropertiesOnExternTypes = false;
    public boolean devirtualizePrototypeMethods = false;
    public boolean computeFunctionSideEffects = false;
    public String debugFunctionSideEffectsPath = null;
    public boolean disambiguateProperties = false;
    public boolean ambiguateProperties = false;
    public AnonymousFunctionNamingPolicy anonymousFunctionNaming;
    public byte[] inputVariableMapSerialized;
    public byte[] inputPropertyMapSerialized;
    public boolean exportTestFunctions = false;
    public boolean specializeInitialModule;
    boolean runtimeTypeCheck = false;
    String runtimeTypeCheckLogFunction = null;
    private CodingConvention codingConvention;
    public boolean instrumentForCoverage = false;
    public boolean instrumentForCoverageOnly = false;
    public boolean ignoreCajaProperties = false;
    public String syntheticBlockStartMarker = null;
    public String syntheticBlockEndMarker = null;
    public String locale = null;
    public boolean markAsCompiled = false;
    public boolean removeTryCatchFinally = false;
    public boolean closurePass = false;
    boolean rewriteNewDateGoogNow = true;
    boolean removeAbstractMethods = true;
    boolean removeClosureAsserts = false;
    public boolean gatherCssNames;
    public Set<String> stripTypes;
    public Set<String> stripNameSuffixes;
    public Set<String> stripNamePrefixes;
    public Set<String> stripTypePrefixes;
    public transient Multimap<CustomPassExecutionTime, CompilerPass> customPasses = null;
    public boolean markNoSideEffectCalls = false;
    private Map<String, Object> defineReplacements;
    private TweakProcessing tweakProcessing;
    private Map<String, Object> tweakReplacements;
    public boolean moveFunctionDeclarations = false;
    public String instrumentationTemplate = null;
    public String appNameStr = "";
    public boolean recordFunctionInformation = false;
    public boolean generateExports = false;
    public CssRenamingMap cssRenamingMap = null;
    boolean processObjectPropertyString = false;
    boolean replaceIdGenerators = true;
    Set<String> idGenerators;
    List<String> replaceStringsFunctionDescriptions;
    String replaceStringsPlaceholderToken = "";
    Set<String> replaceStringsReservedStrings;
    boolean operaCompoundAssignFix = true;
    Map<String, CheckLevel> propertyInvalidationErrors;
    public boolean prettyPrint = false;
    public boolean lineBreak = false;
    public boolean printInputDelimiter = false;
    public String inputDelimiter = "// Input %num%";
    public String reportPath = null;
    public TracerMode tracer;
    private boolean colorizeErrorOutput = false;
    public ErrorFormat errorFormat;
    public String jsOutputFile = "";
    private ComposeWarningsGuard warningsGuard = new ComposeWarningsGuard(new WarningsGuard[0]);
    int summaryDetailLevel = 1;
    int lineLengthThreshold = 500;
    private boolean externExports = false;
    String externExportsPath;
    public String nameReferenceReportPath = null;
    public String nameReferenceGraphPath = null;
    public String sourceMapOutputPath;
    public SourceMap.DetailLevel sourceMapDetailLevel = SourceMap.DetailLevel.SYMBOLS;
    public SourceMap.Format sourceMapFormat = SourceMap.Format.DEFAULT;
    public List<SourceMap.LocationMapping> sourceMapLocationMappings = Collections.emptyList();
    String outputCharset;
    boolean looseTypes;
    private transient AliasTransformationHandler aliasHandler;
    static final AliasTransformationHandler NULL_ALIAS_TRANSFORMATION_HANDLER = new NullAliasTransformationHandler();

    public void setCheckShadowVars(CheckLevel level) {
        this.checkShadowVars = level;
    }

    public void setAggressiveVarCheck(CheckLevel level) {
        this.aggressiveVarCheck = level;
    }

    public void setCheckFunctions(CheckLevel level) {
        this.checkFunctions = level;
    }

    public void setCheckMethods(CheckLevel level) {
        this.checkMethods = level;
    }

    public void setReportMissingOverride(CheckLevel level) {
        this.reportMissingOverride = level;
    }

    public void setReportUnknownTypes(CheckLevel level) {
        this.reportUnknownTypes = level;
    }

    public void setCheckRequires(CheckLevel level) {
        this.checkRequires = level;
    }

    public void setCheckProvides(CheckLevel level) {
        this.checkProvides = level;
    }

    public void setCheckGlobalNamesLevel(CheckLevel level) {
        this.checkGlobalNamesLevel = level;
    }

    public void setBrokenClosureRequiresLevel(CheckLevel level) {
        this.brokenClosureRequiresLevel = level;
    }

    public void setCheckGlobalThisLevel(CheckLevel level) {
        this.checkGlobalThisLevel = level;
    }

    public void setCheckMissingGetCssNameLevel(CheckLevel level) {
        this.checkMissingGetCssNameLevel = level;
    }

    public void setCheckUnreachableCode(CheckLevel level) {
        this.checkUnreachableCode = level;
    }

    public void setCheckMissingReturn(CheckLevel level) {
        this.checkMissingReturn = level;
    }

    public CompilerOptions() {
        this.languageIn = LanguageMode.ECMASCRIPT3;
        this.devMode = DevMode.OFF;
        this.checkShadowVars = CheckLevel.OFF;
        this.aggressiveVarCheck = CheckLevel.OFF;
        this.checkFunctions = CheckLevel.OFF;
        this.checkMethods = CheckLevel.OFF;
        this.reportMissingOverride = CheckLevel.OFF;
        this.reportUnknownTypes = CheckLevel.OFF;
        this.checkRequires = CheckLevel.OFF;
        this.checkProvides = CheckLevel.OFF;
        this.checkGlobalNamesLevel = CheckLevel.OFF;
        this.brokenClosureRequiresLevel = CheckLevel.ERROR;
        this.checkGlobalThisLevel = CheckLevel.OFF;
        this.checkUnreachableCode = CheckLevel.OFF;
        this.checkMissingReturn = CheckLevel.OFF;
        this.checkMissingGetCssNameLevel = CheckLevel.OFF;
        this.aliasableStrings = Collections.emptySet();
        this.variableRenaming = VariableRenamingPolicy.OFF;
        this.propertyRenaming = PropertyRenamingPolicy.OFF;
        this.anonymousFunctionNaming = AnonymousFunctionNamingPolicy.OFF;
        this.stripTypes = Collections.emptySet();
        this.stripNameSuffixes = Collections.emptySet();
        this.stripNamePrefixes = Collections.emptySet();
        this.stripTypePrefixes = Collections.emptySet();
        this.defineReplacements = Maps.newHashMap();
        this.tweakProcessing = TweakProcessing.OFF;
        this.tweakReplacements = Maps.newHashMap();
        this.idGenerators = Collections.emptySet();
        this.replaceStringsFunctionDescriptions = Collections.emptyList();
        this.replaceStringsReservedStrings = Collections.emptySet();
        this.propertyInvalidationErrors = Maps.newHashMap();
        this.tracer = TracerMode.OFF;
        this.errorFormat = ErrorFormat.SINGLELINE;
        this.aliasHandler = NULL_ALIAS_TRANSFORMATION_HANDLER;
    }

    public Map<String, Node> getDefineReplacements() {
        return CompilerOptions.getReplacementsHelper(this.defineReplacements);
    }

    public Map<String, Node> getTweakReplacements() {
        return CompilerOptions.getReplacementsHelper(this.tweakReplacements);
    }

    private static Map<String, Node> getReplacementsHelper(Map<String, Object> source) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                map.put(name, (Boolean)value != false ? new Node(44) : new Node(43));
                continue;
            }
            if (value instanceof Integer) {
                map.put(name, Node.newNumber(((Integer)value).intValue()));
                continue;
            }
            if (value instanceof Double) {
                map.put(name, Node.newNumber((Double)value));
                continue;
            }
            Preconditions.checkState((boolean)(value instanceof String));
            map.put(name, Node.newString((String)value));
        }
        return map;
    }

    public void setDefineToBooleanLiteral(String defineName, boolean value) {
        this.defineReplacements.put(defineName, new Boolean(value));
    }

    public void setDefineToStringLiteral(String defineName, String value) {
        this.defineReplacements.put(defineName, value);
    }

    public void setDefineToNumberLiteral(String defineName, int value) {
        this.defineReplacements.put(defineName, new Integer(value));
    }

    public void setDefineToDoubleLiteral(String defineName, double value) {
        this.defineReplacements.put(defineName, new Double(value));
    }

    public void setTweakToBooleanLiteral(String tweakId, boolean value) {
        this.tweakReplacements.put(tweakId, new Boolean(value));
    }

    public void setTweakToStringLiteral(String tweakId, String value) {
        this.tweakReplacements.put(tweakId, value);
    }

    public void setTweakToNumberLiteral(String tweakId, int value) {
        this.tweakReplacements.put(tweakId, new Integer(value));
    }

    public void setTweakToDoubleLiteral(String tweakId, double value) {
        this.tweakReplacements.put(tweakId, new Double(value));
    }

    public void skipAllCompilerPasses() {
        this.skipAllPasses = true;
    }

    boolean enables(DiagnosticGroup type) {
        return this.warningsGuard.enables(type);
    }

    boolean disables(DiagnosticGroup type) {
        return this.warningsGuard.disables(type);
    }

    public void setWarningLevel(DiagnosticGroup type, CheckLevel level) {
        this.addWarningsGuard(new DiagnosticGroupWarningsGuard(type, level));
    }

    WarningsGuard getWarningsGuard() {
        return this.warningsGuard;
    }

    public void resetWarningsGuard() {
        this.warningsGuard = new ComposeWarningsGuard(new WarningsGuard[0]);
    }

    void useEmergencyFailSafe() {
        this.warningsGuard = this.warningsGuard.makeEmergencyFailSafeGuard();
    }

    public void addWarningsGuard(WarningsGuard guard) {
        this.warningsGuard.addGuard(guard);
    }

    public void setRenamingPolicy(VariableRenamingPolicy newVariablePolicy, PropertyRenamingPolicy newPropertyPolicy) {
        this.variableRenaming = newVariablePolicy;
        this.propertyRenaming = newPropertyPolicy;
    }

    public void setPropertyAffinity(boolean useAffinity) {
        this.propertyAffinity = useAffinity;
    }

    public void setShadowVariables(boolean shadow) {
        this.shadowVariables = shadow;
    }

    public void setCollapsePropertiesOnExternTypes(boolean collapse) {
        this.collapsePropertiesOnExternTypes = collapse;
    }

    public void setProcessObjectPropertyString(boolean process) {
        this.processObjectPropertyString = process;
    }

    public void setReplaceIdGenerators(boolean replaceIdGenerators) {
        this.replaceIdGenerators = replaceIdGenerators;
    }

    public void setIdGenerators(Set<String> idGenerators) {
        this.idGenerators = Sets.newHashSet(idGenerators);
    }

    public void setInlineFunctions(Reach reach) {
        switch (reach) {
            case ALL: {
                this.inlineFunctions = true;
                this.inlineLocalFunctions = true;
                break;
            }
            case LOCAL_ONLY: {
                this.inlineFunctions = false;
                this.inlineLocalFunctions = true;
                break;
            }
            case NONE: {
                this.inlineFunctions = false;
                this.inlineLocalFunctions = false;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
    }

    public void setInlineVariables(Reach reach) {
        switch (reach) {
            case ALL: {
                this.inlineVariables = true;
                this.inlineLocalVariables = true;
                break;
            }
            case LOCAL_ONLY: {
                this.inlineVariables = false;
                this.inlineLocalVariables = true;
                break;
            }
            case NONE: {
                this.inlineVariables = false;
                this.inlineLocalVariables = false;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
    }

    public void setRemoveUnusedVariable(Reach reach) {
        switch (reach) {
            case ALL: {
                this.removeUnusedVars = true;
                this.removeUnusedLocalVars = true;
                break;
            }
            case LOCAL_ONLY: {
                this.removeUnusedVars = false;
                this.removeUnusedLocalVars = true;
                break;
            }
            case NONE: {
                this.removeUnusedVars = false;
                this.removeUnusedLocalVars = false;
                break;
            }
            default: {
                throw new IllegalStateException("unexpected");
            }
        }
    }

    public void setReplaceStringsConfiguration(String placeholderToken, List<String> functionDescriptors) {
        this.replaceStringsPlaceholderToken = placeholderToken;
        this.replaceStringsFunctionDescriptions = Lists.newArrayList(functionDescriptors);
    }

    public void setRewriteNewDateGoogNow(boolean rewrite) {
        this.rewriteNewDateGoogNow = rewrite;
    }

    public void setRemoveAbstractMethods(boolean remove) {
        this.removeAbstractMethods = remove;
    }

    public void setRemoveClosureAsserts(boolean remove) {
        this.removeClosureAsserts = remove;
    }

    public void setNameAnonymousFunctionsOnly(boolean value) {
        this.nameAnonymousFunctionsOnly = value;
    }

    public void lineLengthThreshold(int value) {
        this.lineLengthThreshold = value;
    }

    public void setColorizeErrorOutput(boolean colorizeErrorOutput) {
        this.colorizeErrorOutput = colorizeErrorOutput;
    }

    public boolean shouldColorizeErrorOutput() {
        return this.colorizeErrorOutput;
    }

    public void setChainCalls(boolean value) {
        this.chainCalls = value;
    }

    public void setAcceptConstKeyword(boolean value) {
        this.acceptConstKeyword = value;
    }

    public void enableRuntimeTypeCheck(String logFunction) {
        this.runtimeTypeCheck = true;
        this.runtimeTypeCheckLogFunction = logFunction;
    }

    public void disableRuntimeTypeCheck() {
        this.runtimeTypeCheck = false;
    }

    public void setGenerateExports(boolean generateExports) {
        this.generateExports = generateExports;
    }

    public void setCodingConvention(CodingConvention codingConvention) {
        this.codingConvention = codingConvention;
    }

    public CodingConvention getCodingConvention() {
        return this.codingConvention;
    }

    public void setManageClosureDependencies(boolean newVal) {
        this.manageClosureDependencies = newVal;
    }

    public void setManageClosureDependencies(List<String> entryPoints) {
        Preconditions.checkNotNull(entryPoints);
        this.manageClosureDependencies = true;
        this.manageClosureDependenciesEntryPoints = entryPoints;
    }

    public void setSummaryDetailLevel(int summaryDetailLevel) {
        this.summaryDetailLevel = summaryDetailLevel;
    }

    public void enableExternExports(boolean enable) {
        this.externExports = enable;
    }

    public void setExtraAnnotationNames(Set<String> extraAnnotationNames) {
        this.extraAnnotationNames = Sets.newHashSet(extraAnnotationNames);
    }

    public boolean isExternExportsEnabled() {
        return this.externExports;
    }

    public void setOutputCharset(String charsetName) {
        this.outputCharset = charsetName;
    }

    public void setTweakProcessing(TweakProcessing tweakProcessing) {
        this.tweakProcessing = tweakProcessing;
    }

    public TweakProcessing getTweakProcessing() {
        return this.tweakProcessing;
    }

    public void setLanguageIn(LanguageMode languageIn) {
        this.languageIn = languageIn;
        this.languageOut = languageIn;
    }

    public LanguageMode getLanguageIn() {
        return this.languageIn;
    }

    public LanguageMode getLanguageOut() {
        return this.languageOut;
    }

    public void setLooseTypes(boolean looseTypes) {
        this.looseTypes = looseTypes;
    }

    public Object clone() throws CloneNotSupportedException {
        CompilerOptions clone = (CompilerOptions)super.clone();
        return clone;
    }

    public void setAliasTransformationHandler(AliasTransformationHandler changes) {
        this.aliasHandler = changes;
    }

    public AliasTransformationHandler getAliasTransformationHandler() {
        return this.aliasHandler;
    }

    public void setInferTypes(boolean enable) {
        this.inferTypes = enable;
    }

    public boolean getInferTypes() {
        return this.inferTypes;
    }

    public boolean assumeStrictThis() {
        return this.assumeStrictThis;
    }

    public void setAssumeStrictThis(boolean enable) {
        this.assumeStrictThis = enable;
    }

    public boolean assumeClosuresOnlyCaptureReferences() {
        return this.assumeClosuresOnlyCaptureReferences;
    }

    public void setAssumeClosuresOnlyCaptureReferences(boolean enable) {
        this.assumeClosuresOnlyCaptureReferences = enable;
    }

    public void setPropertyInvalidationErrors(Map<String, CheckLevel> propertyInvalidationErrors) {
        this.propertyInvalidationErrors = Maps.newHashMap(propertyInvalidationErrors);
    }

    private static class NullAliasTransformationHandler
    implements AliasTransformationHandler,
    Serializable {
        private static final long serialVersionUID = 0L;
        private static final AliasTransformation NULL_ALIAS_TRANSFORMATION = new NullAliasTransformation();

        private NullAliasTransformationHandler() {
        }

        @Override
        public AliasTransformation logAliasTransformation(String sourceFile, SourcePosition<AliasTransformation> position) {
            position.setItem(NULL_ALIAS_TRANSFORMATION);
            return NULL_ALIAS_TRANSFORMATION;
        }

        private static class NullAliasTransformation
        implements AliasTransformation,
        Serializable {
            private static final long serialVersionUID = 0L;

            private NullAliasTransformation() {
            }

            @Override
            public void addAlias(String alias, String definition) {
            }
        }
    }

    public static interface AliasTransformation {
        public void addAlias(String var1, String var2);
    }

    public static interface AliasTransformationHandler {
        public AliasTransformation logAliasTransformation(String var1, SourcePosition<AliasTransformation> var2);
    }

    public static enum TweakProcessing {
        OFF,
        CHECK,
        STRIP;


        public boolean isOn() {
            return this != OFF;
        }

        public boolean shouldStrip() {
            return this == STRIP;
        }
    }

    public static enum TracerMode {
        ALL,
        FAST,
        OFF;


        boolean isOn() {
            return this != OFF;
        }
    }

    static enum DevMode {
        OFF,
        START,
        START_AND_END,
        EVERY_PASS;

    }

    public static enum LanguageMode {
        ECMASCRIPT3,
        ECMASCRIPT5,
        ECMASCRIPT5_STRICT;

    }

    public static enum Reach {
        ALL,
        LOCAL_ONLY,
        NONE;

    }
}

