/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CalculateModeratorEventListener
implements EventListener {
    private String path_;
    private String workspace_;
    private String repository_;
    private Log log = ExoLogger.getLogger(CalculateModeratorEventListener.class);

    public String getSrcWorkspace() {
        return this.workspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public String getPath() {
        return this.path_;
    }

    public void setPath(String path) {
        this.path_ = path;
    }

    public void onEvent(EventIterator evIter) {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            ForumService forumService = (ForumService)container.getComponentInstanceOfType(ForumService.class);
            while (evIter.hasNext()) {
                String evPath;
                Event ev = evIter.nextEvent();
                if (ev.getType() == 1) {
                    evPath = ev.getPath();
                    forumService.calculateModerator(evPath, true);
                    continue;
                }
                if (ev.getType() == 16) {
                    evPath = ev.getPath();
                    if (!evPath.substring(evPath.lastIndexOf("/") + 1).equals("exo:moderators")) continue;
                    forumService.calculateModerator(evPath.substring(0, evPath.lastIndexOf("/") + 1), false);
                    continue;
                }
                if (ev.getType() != 2) continue;
                evPath = ev.getPath();
                forumService.calculateModerator(evPath, false);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to calculate moderators");
        }
    }
}

