/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.config;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.config.ConfigContributor;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.ModulePrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CoreUtilConfigContributor
implements ConfigContributor {
    private final FeatureRegistry registry;

    @Inject
    public CoreUtilConfigContributor(FeatureRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void contribute(Map<String, Object> config, Gadget gadget) {
        ModulePrefs prefs = gadget.getSpec().getModulePrefs();
        Collection<Feature> features = prefs.getFeatures().values();
        HashMap featureMap = Maps.newHashMapWithExpectedSize((int)features.size());
        Set<String> allFeatureNames = this.registry.getAllFeatureNames();
        for (Feature feature : features) {
            if (!allFeatureNames.contains(feature.getName())) continue;
            HashMap paramFeaturesInConfig = Maps.newHashMap();
            for (String paramName : feature.getParams().keySet()) {
                Collection paramValues = feature.getParams().get((Object)paramName);
                if (paramValues.size() == 1) {
                    paramFeaturesInConfig.put(paramName, paramValues.iterator().next());
                    continue;
                }
                paramFeaturesInConfig.put(paramName, paramValues);
            }
            featureMap.put(feature.getName(), paramFeaturesInConfig);
        }
        config.put("core.util", featureMap);
    }

    @Override
    public void contribute(Map<String, Object> config, String container, String host) {
    }
}

