/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.filter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.filter.Filter;
import org.apache.pdfbox.filter.TIFFFaxDecoder;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.ccitt.CCITTFaxG31DDecodeInputStream;
import org.apache.pdfbox.io.ccitt.FillOrderChangeInputStream;

public class CCITTFaxDecodeFilter
implements Filter {
    private static final Log log = LogFactory.getLog(CCITTFaxDecodeFilter.class);

    public void decode(InputStream compressedData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        COSBase decodeP = options.getDictionaryObject(COSName.DECODE_PARMS, COSName.DP);
        COSDictionary decodeParms = null;
        if (decodeP instanceof COSDictionary) {
            decodeParms = (COSDictionary)decodeP;
        } else if (decodeP instanceof COSArray) {
            decodeParms = (COSDictionary)((COSArray)decodeP).get(filterIndex);
        }
        int length = options.getInt(COSName.LENGTH, -1);
        byte[] compressed = null;
        if (length != -1) {
            compressed = new byte[length];
            long written = IOUtils.populateBuffer(compressedData, compressed);
            if (written != (long)compressed.length) {
                log.warn((Object)"Buffer for compressed data did not match the length of the actual compressed data");
            }
        } else {
            compressed = IOUtils.toByteArray(compressedData);
        }
        int cols = decodeParms.getInt(COSName.COLUMNS, 1728);
        int rows = decodeParms.getInt(COSName.ROWS, 0);
        int height = options.getInt(COSName.HEIGHT, COSName.H, 0);
        rows = rows > 0 && height > 0 ? Math.min(rows, height) : Math.max(rows, height);
        int k = decodeParms.getInt(COSName.K, 0);
        int arraySize = (cols + 7) / 8 * rows;
        TIFFFaxDecoder faxDecoder = new TIFFFaxDecoder(1, cols, rows);
        long tiffOptions = 0L;
        if (k == 0) {
            InputStream in = new CCITTFaxG31DDecodeInputStream(new ByteArrayInputStream(compressed), cols);
            in = new FillOrderChangeInputStream(in);
            IOUtils.copy(in, result);
            in.close();
        } else if (k > 0) {
            byte[] decompressed = new byte[arraySize];
            faxDecoder.decode2D(decompressed, compressed, 0, rows, tiffOptions);
            result.write(decompressed);
        } else if (k < 0) {
            byte[] decompressed = new byte[arraySize];
            faxDecoder.decodeT6(decompressed, compressed, 0, rows, tiffOptions);
            result.write(decompressed);
        }
    }

    public void encode(InputStream rawData, OutputStream result, COSDictionary options, int filterIndex) throws IOException {
        log.warn((Object)"CCITTFaxDecode.encode is not implemented yet, skipping this stream.");
    }
}

