/*
 * Decompiled with CFR 0.152.
 */
package org.josso.gateway;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.SecurityDomain;
import org.josso.gateway.session.SSOSession;

public abstract class SSOContext {
    protected static ThreadLocal<SSOContext> ctx = new ThreadLocal();
    private static final Log logger = LogFactory.getLog(SSOContext.class);
    protected String scheme;
    protected String userLocation;
    protected SSOSession ssoSession;
    protected SecurityDomain securityDomain;

    protected SSOContext() {
        ctx.set(this);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created context in thread " + Thread.currentThread().getName()));
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public SSOSession getSession() {
        return this.ssoSession;
    }

    public String getUserLocation() {
        return this.userLocation;
    }

    public SecurityDomain getSecurityDomain() {
        return this.securityDomain;
    }

    public static SSOContext getCurrent() {
        return ctx.get();
    }
}

