/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.application;

import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.portal.application.PortalRequestHandler;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserNodeFilterConfig;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.portal.url.PortalURLContext;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebRequestHandler;
import org.exoplatform.web.url.MimeType;
import org.exoplatform.web.url.URLContext;
import org.exoplatform.web.url.URLFactoryService;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;

public class LegacyRequestHandler
extends WebRequestHandler {
    private final URLFactoryService urlFactory;
    private final UserPortalConfigService userPortalService;
    private final UserPortalContext userPortalContext = new UserPortalContext(){

        public ResourceBundle getBundle(UserNavigation navigation) {
            return null;
        }

        public Locale getUserLocale() {
            return Locale.ENGLISH;
        }
    };

    public LegacyRequestHandler(URLFactoryService urlFactory, UserPortalConfigService userPortalService) {
        this.urlFactory = urlFactory;
        this.userPortalService = userPortalService;
    }

    public String getHandlerName() {
        return "legacy";
    }

    public boolean execute(ControllerContext context) throws Exception {
        UserNodeFilterConfig.Builder builder;
        UserPortal userPortal;
        UserNode userNode;
        UserPortalConfig cfg;
        String requestSiteName = context.getParameter(PortalRequestHandler.REQUEST_SITE_NAME);
        String requestPath = context.getParameter(PortalRequestHandler.REQUEST_PATH);
        String requestURI = context.getRequest().getRequestURI();
        HttpServletRequest request = context.getRequest();
        HttpServletResponse response = context.getResponse();
        if (requestURI.startsWith(request.getContextPath() + "/private/") && request.getRemoteUser() == null) {
            String doLoginPath = request.getContextPath() + "/login" + "?initialURI=" + request.getRequestURI();
            response.sendRedirect(response.encodeRedirectURL(doLoginPath));
            return true;
        }
        SiteKey siteKey = SiteKey.portal((String)requestSiteName);
        String uri = requestPath;
        if (!requestPath.equals("") && (cfg = this.userPortalService.getUserPortalConfig(requestSiteName, request.getRemoteUser(), this.userPortalContext)) != null && (userNode = (userPortal = cfg.getUserPortal()).resolvePath((builder = UserNodeFilterConfig.builder().withAuthMode(1)).build(), requestPath)) != null) {
            siteKey = userNode.getNavigation().getKey();
            uri = userNode.getURI();
        }
        PortalURLContext urlContext = new PortalURLContext(context, siteKey);
        NodeURL url = (NodeURL)this.urlFactory.newURL(NodeURL.TYPE, (URLContext)urlContext);
        url.setResource(new NavigationResource(siteKey.getType(), siteKey.getName(), uri));
        url.setMimeType(MimeType.PLAIN);
        Enumeration paraNames = request.getParameterNames();
        while (paraNames.hasMoreElements()) {
            String parameter = paraNames.nextElement().toString();
            url.setQueryParameterValues(parameter, request.getParameterValues(parameter));
        }
        String s = url.toString();
        response.sendRedirect(response.encodeRedirectURL(s));
        return true;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }
}

