/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.rendering.converter;

import java.io.Reader;
import java.io.StringReader;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wiki.rendering.converter.ConfluenceToXWiki2DeepTransformation;
import org.xwiki.component.embed.EmbeddableComponentManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.converter.ConversionException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.TransformationContext;

public class ConfluenceToXWiki2Transformer {
    private static Log logger = ExoLogger.getExoLogger(ConfluenceToXWiki2Transformer.class);

    public static String transformContent(String content, ComponentManager componentManager) {
        Syntax sourceSyntax = Syntax.CONFLUENCE_1_0;
        Syntax targetSyntax = Syntax.XWIKI_2_0;
        if (componentManager == null) {
            componentManager = new EmbeddableComponentManager();
        }
        try {
            Parser parser = (Parser)componentManager.getInstance(Parser.class, sourceSyntax.toIdString());
            XDOM xdom = parser.parse((Reader)new StringReader(content));
            WikiPrinter printer = ConfluenceToXWiki2Transformer.convert(xdom, sourceSyntax, targetSyntax, componentManager);
            return printer.toString();
        }
        catch (ComponentLookupException e) {
            logger.warn((Object)"Transformation failure: ", (Throwable)e);
        }
        catch (ConversionException e) {
            logger.warn((Object)"Transformation failure: ", (Throwable)e);
        }
        catch (Exception e) {
            logger.warn((Object)"Transformation failure: ", (Throwable)e);
        }
        return content;
    }

    private static WikiPrinter convert(XDOM xdom, Syntax sourceSyntax, Syntax targetSyntax, ComponentManager componentManager) throws Exception {
        BlockRenderer renderer;
        ConfluenceToXWiki2DeepTransformation transformation = ConfluenceToXWiki2DeepTransformation.getInstance();
        transformation.setComponentManager(componentManager);
        transformation.transform((Block)xdom, new TransformationContext(xdom, sourceSyntax));
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        try {
            renderer = (BlockRenderer)componentManager.getInstance(BlockRenderer.class, targetSyntax.toIdString());
        }
        catch (ComponentLookupException e) {
            throw new ConversionException("Failed to locate Renderer for syntax [" + targetSyntax + "]", (Throwable)e);
        }
        renderer.render((Block)xdom, (WikiPrinter)printer);
        return printer;
    }
}

