/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.clean.rdbms;

import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.database.utils.JDBCUtils;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;
import org.exoplatform.services.jcr.impl.clean.rdbms.DBCleanException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCleanerTool {
    protected static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.DBCleaner");
    protected final Connection connection;
    protected final boolean autoCommit;
    protected final List<String> rollbackingScripts = new ArrayList<String>();
    protected final List<String> committingScripts = new ArrayList<String>();
    protected final List<String> cleaningScripts = new ArrayList<String>();

    DBCleanerTool(Connection connection, boolean autoCommit, Collection<String> cleaningScripts, Collection<String> committingScripts, Collection<String> rollbackingScripts) {
        this.connection = connection;
        this.autoCommit = autoCommit;
        this.cleaningScripts.addAll(cleaningScripts);
        this.committingScripts.addAll(committingScripts);
        this.rollbackingScripts.addAll(rollbackingScripts);
    }

    public void clean() throws DBCleanException {
        try {
            this.execute(this.cleaningScripts);
        }
        catch (SQLException e) {
            throw new DBCleanException(JDBCUtils.getFullMessage((SQLException)e), e);
        }
    }

    public void commit() throws DBCleanException {
        try {
            this.execute(this.committingScripts);
        }
        catch (SQLException e) {
            throw new DBCleanException(JDBCUtils.getFullMessage((SQLException)e), e);
        }
    }

    public void rollback() throws DBCleanException {
        try {
            this.execute(this.rollbackingScripts);
        }
        catch (SQLException e) {
            throw new DBCleanException(JDBCUtils.getFullMessage((SQLException)e), e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(List<String> scripts) throws SQLException {
        SecurityHelper.validateSecurityPermission((Permission)JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        boolean autoCommit = this.connection.getAutoCommit();
        if (autoCommit != this.autoCommit) {
            this.connection.setAutoCommit(this.autoCommit);
        }
        Statement st = this.connection.createStatement();
        try {
            for (String scr : scripts) {
                String sql = JDBCUtils.cleanWhitespaces((String)scr.trim());
                if (sql.isEmpty()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Execute script: \n[" + sql + "]"));
                }
                this.executeQuery(st, sql);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                st.close();
            }
            catch (SQLException e) {
                LOG.error((Object)("Can't close the Statement." + e.getMessage()));
            }
            if (autoCommit != this.autoCommit) {
                this.connection.setAutoCommit(autoCommit);
            }
            throw throwable;
        }
        try {
            st.close();
        }
        catch (SQLException e) {
            LOG.error((Object)("Can't close the Statement." + e.getMessage()));
        }
        if (autoCommit != this.autoCommit) {
            this.connection.setAutoCommit(autoCommit);
        }
    }

    protected void executeQuery(final Statement statement, final String sql) throws SQLException {
        try {
            long start = 0L;
            if (LOG.isDebugEnabled()) {
                start = System.currentTimeMillis();
                LOG.debug((Object)("Execute script: \n[" + sql + "]"));
            }
            SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    statement.executeUpdate(sql);
                    return null;
                }
            });
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Script " + sql + " executed in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " sec"));
            }
        }
        catch (SQLException e) {
            LOG.error((Object)("Query execution \"" + sql + "\" failed: " + JDBCUtils.getFullMessage((SQLException)e)), (Throwable)e);
            throw e;
        }
    }
}

