/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.collections.iterators.IteratorChain;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingConfiguration;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodeTraversingQueryHits
extends AbstractQueryHits {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.NodeTraversingQueryHits");
    private final Iterator nodes;
    private IndexingConfiguration indexConfig;

    public NodeTraversingQueryHits(Node start, boolean includeStart, IndexingConfiguration indexConfig) {
        this(start, includeStart, Integer.MAX_VALUE, indexConfig);
    }

    public NodeTraversingQueryHits(Node start, boolean includeStart, int maxDepth, IndexingConfiguration indexConfig) {
        this.nodes = new TraversingNodeIterator(start, maxDepth);
        this.indexConfig = indexConfig;
        if (!includeStart) {
            this.nodes.next();
        }
    }

    public ScoreNode nextScoreNode() throws IOException {
        if (this.nodes.hasNext()) {
            NodeImpl n = (NodeImpl)this.nodes.next();
            return new ScoreNode(n.getData().getIdentifier(), 1.0f);
        }
        return null;
    }

    private class TraversingNodeIterator
    implements Iterator {
        private final Node currentNode;
        private final int maxDepth;
        private Iterator selfAndChildren;

        TraversingNodeIterator(Node start, int maxDepth) {
            if (maxDepth < 0) {
                throw new IllegalArgumentException("maxDepth must be >= 0");
            }
            this.currentNode = start;
            this.maxDepth = maxDepth;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public boolean hasNext() {
            this.init();
            return this.selfAndChildren.hasNext();
        }

        public Object next() {
            this.init();
            NodeImpl n = (NodeImpl)this.selfAndChildren.next();
            return n;
        }

        private void init() {
            if (this.selfAndChildren == null) {
                ArrayList<Iterator<Object>> allIterators;
                block10: {
                    allIterators = new ArrayList<Iterator<Object>>();
                    Iterator<Node> current = Collections.singletonList(this.currentNode).iterator();
                    allIterators.add(current);
                    if (this.maxDepth != 0) {
                        if (this.maxDepth == 1) {
                            try {
                                allIterators.add((Iterator<Object>)this.currentNode.getNodes());
                            }
                            catch (RepositoryException e) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                                }
                                break block10;
                            }
                        }
                        try {
                            if (NodeTraversingQueryHits.this.indexConfig == null || !NodeTraversingQueryHits.this.indexConfig.isExcluded((NodeData)((NodeImpl)this.currentNode).getData())) {
                                NodeIterator children = this.currentNode.getNodes();
                                while (children.hasNext()) {
                                    NodeImpl node = (NodeImpl)children.nextNode();
                                    if (NodeTraversingQueryHits.this.indexConfig != null && NodeTraversingQueryHits.this.indexConfig.isExcluded((NodeData)node.getData())) continue;
                                    allIterators.add(new TraversingNodeIterator(node, this.maxDepth - 1));
                                }
                            }
                        }
                        catch (RepositoryException e) {
                            if (!LOG.isTraceEnabled()) break block10;
                            LOG.trace((Object)("An exception occurred: " + e.getMessage()));
                        }
                    }
                }
                this.selfAndChildren = new IteratorChain(allIterators);
            }
        }
    }
}

