/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.web;

import java.io.IOException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.frameworks.jcr.command.web.GenericWebAppContext;
import org.exoplatform.services.command.impl.CommandService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class CommandControllerServlet
extends HttpServlet {
    private static Log log = ExoLogger.getLogger((String)"exo.jcr.framework.command.CommandControllerServlet");

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        GenericWebAppContext ctx;
        ServletContext servletCtx = this.getServletContext();
        ExoContainer container = (ExoContainer)servletCtx.getAttribute("org.exoplatform.frameworks.web.eXoContainer");
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        boolean hasChanged = false;
        ClassLoader pcClassLoader = null;
        if (container == null && (container = PortalContainer.getCurrentInstance((ServletContext)servletCtx)) instanceof PortalContainer) {
            PortalContainer pc = (PortalContainer)container;
            pcClassLoader = pc.getPortalClassLoader();
            servletCtx = pc.getPortalContext();
        }
        SessionProviderService sessionProviderService = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        try {
            ctx = new GenericWebAppContext(servletCtx, request, response, sessionProviderService.getSessionProvider(null), repositoryService.getDefaultRepository());
        }
        catch (RepositoryException e) {
            throw new IOException(){

                public Throwable getCause() {
                    return e;
                }
            };
        }
        catch (RepositoryConfigurationException e) {
            throw new IOException(){

                public Throwable getCause() {
                    return e;
                }
            };
        }
        CommandService commandService = (CommandService)container.getComponentInstanceOfType(CommandService.class);
        String catalogName = (String)ctx.get("org.exoplatform.frameworks.web.catalogName");
        String commandName = (String)ctx.get("Command");
        if (commandName == null) {
            throw new ServletException("No Command found at the Context");
        }
        Command cmd = catalogName == null ? commandService.getCatalog().getCommand(commandName) : commandService.getCatalog(catalogName).getCommand(commandName);
        if (cmd == null) {
            throw new ServletException("No Command found " + commandName);
        }
        try {
            if (pcClassLoader != null) {
                Thread.currentThread().setContextClassLoader(pcClassLoader);
                hasChanged = true;
            }
            cmd.execute((Context)ctx);
        }
        catch (Exception e) {
            log.error((Object)("An error occurs while executing the command " + commandName), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        finally {
            if (hasChanged) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
    }
}

