/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.application.registry.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.chromattic.api.ChromatticSession;
import org.exoplatform.application.gadget.Gadget;
import org.exoplatform.application.gadget.GadgetRegistryService;
import org.exoplatform.application.registry.Application;
import org.exoplatform.application.registry.ApplicationCategoriesPlugins;
import org.exoplatform.application.registry.ApplicationCategory;
import org.exoplatform.application.registry.ApplicationRegistryService;
import org.exoplatform.application.registry.impl.ApplicationRegistryChromatticLifeCycle;
import org.exoplatform.application.registry.impl.CategoryDefinition;
import org.exoplatform.application.registry.impl.ContentDefinition;
import org.exoplatform.application.registry.impl.ContentRegistry;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.portal.pom.spi.wsrp.WSRP;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.mop.api.content.ContentType;
import org.gatein.mop.api.content.Customization;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.picocontainer.Startable;

public class ApplicationRegistryServiceImpl
implements ApplicationRegistryService,
Startable {
    private static final String INTERNAL_PORTLET_TAG = "gatein_internal";
    private static final String REMOTE_CATEGORY_NAME = "remote";
    private List<ApplicationCategoriesPlugins> plugins;
    private final ChromatticManager manager;
    private final ChromatticLifeCycle lifeCycle;
    private final Logger log = LoggerFactory.getLogger(ApplicationRegistryServiceImpl.class);
    final POMSessionManager mopManager;
    private static final String PRODUCER_NAME_META_INFO_KEY = "producer-name";
    public static final String PRODUCER_CATEGORY_NAME_SUFFIX = " Producer";

    public ApplicationRegistryServiceImpl(ChromatticManager manager, POMSessionManager mopManager) {
        ApplicationRegistryChromatticLifeCycle lifeCycle = (ApplicationRegistryChromatticLifeCycle)manager.getLifeCycle("app");
        lifeCycle.registry = this;
        this.manager = manager;
        this.lifeCycle = lifeCycle;
        this.mopManager = mopManager;
    }

    public ContentRegistry getContentRegistry() {
        ChromatticSession session = this.lifeCycle.getChromattic().openSession();
        ContentRegistry registry = (ContentRegistry)session.findByPath(ContentRegistry.class, "app:applications");
        if (registry == null) {
            registry = (ContentRegistry)session.insert(ContentRegistry.class, "app:applications");
        }
        return registry;
    }

    @Override
    public void initListener(ComponentPlugin com) {
        if (com instanceof ApplicationCategoriesPlugins) {
            if (this.plugins == null) {
                this.plugins = new ArrayList<ApplicationCategoriesPlugins>();
            }
            this.plugins.add((ApplicationCategoriesPlugins)com);
        }
    }

    public List<ApplicationCategory> getApplicationCategories(Comparator<ApplicationCategory> sortComparator, String accessUser, ApplicationType<?> ... appTypes) {
        ArrayList<ApplicationCategory> categories = new ArrayList<ApplicationCategory>();
        ContentRegistry registry = this.getContentRegistry();
        for (CategoryDefinition categoryDef : registry.getCategoryList()) {
            ApplicationCategory category = this.load(categoryDef, appTypes);
            categories.add(category);
        }
        if (sortComparator != null) {
            Collections.sort(categories, sortComparator);
        }
        return categories;
    }

    @Override
    public List<ApplicationCategory> getApplicationCategories(String accessUser, ApplicationType<?> ... appTypes) throws Exception {
        return this.getApplicationCategories(null, accessUser, appTypes);
    }

    @Override
    public List<ApplicationCategory> getApplicationCategories() throws Exception {
        return this.getApplicationCategories(null);
    }

    @Override
    public List<ApplicationCategory> getApplicationCategories(Comparator<ApplicationCategory> sortComparator) throws Exception {
        return this.getApplicationCategories(sortComparator, null, new ApplicationType[0]);
    }

    @Override
    public ApplicationCategory getApplicationCategory(String name) {
        ContentRegistry registry = this.getContentRegistry();
        CategoryDefinition categoryDef = registry.getCategory(name);
        if (categoryDef != null) {
            ApplicationCategory applicationCategory = this.load(categoryDef, new ApplicationType[0]);
            return applicationCategory;
        }
        return null;
    }

    @Override
    public void save(ApplicationCategory category) {
        String categoryName;
        ContentRegistry registry = this.getContentRegistry();
        CategoryDefinition categoryDef = registry.getCategory(categoryName = category.getName());
        if (categoryDef == null) {
            categoryDef = registry.createCategory(categoryName);
        }
        categoryDef.setDisplayName(category.getDisplayName());
        categoryDef.setCreationDate(category.getCreatedDate());
        categoryDef.setLastModificationDate(category.getModifiedDate());
        categoryDef.setDescription(category.getDescription());
        categoryDef.setAccessPermissions(category.getAccessPermissions());
    }

    @Override
    public void remove(ApplicationCategory category) {
        ContentRegistry registry = this.getContentRegistry();
        registry.getCategoryMap().remove(category.getName());
    }

    @Override
    public List<Application> getApplications(ApplicationCategory category, ApplicationType<?> ... appTypes) throws Exception {
        return this.getApplications(category, (Comparator<Application>)null, appTypes);
    }

    @Override
    public List<Application> getApplications(ApplicationCategory category, Comparator<Application> sortComparator, ApplicationType<?> ... appTypes) {
        ContentRegistry registry = this.getContentRegistry();
        CategoryDefinition categoryDef = registry.getCategory(category.getName());
        List<Application> applications = this.load(categoryDef, appTypes).getApplications();
        if (sortComparator != null) {
            Collections.sort(applications, sortComparator);
        }
        return applications;
    }

    @Override
    public List<Application> getAllApplications() throws Exception {
        ArrayList<Application> applications = new ArrayList<Application>();
        List<ApplicationCategory> categories = this.getApplicationCategories();
        for (ApplicationCategory category : categories) {
            applications.addAll(this.getApplications(category, new ApplicationType[0]));
        }
        return applications;
    }

    @Override
    public Application getApplication(String id) throws Exception {
        String[] fragments = id.split("/");
        if (fragments.length < 2) {
            throw new Exception("Invalid Application Id: [" + id + "]");
        }
        String category = fragments[0];
        String applicationName = fragments[1];
        if (fragments.length == 3 && applicationName.length() == 0) {
            applicationName = "/" + fragments[2];
        }
        return this.getApplication(category, applicationName);
    }

    @Override
    public Application getApplication(String category, String name) {
        ContentDefinition contentDef;
        ContentRegistry registry = this.getContentRegistry();
        CategoryDefinition categoryDef = registry.getCategory(category);
        if (categoryDef != null && (contentDef = categoryDef.getContentMap().get(name)) != null) {
            return this.load(contentDef);
        }
        return null;
    }

    @Override
    public void save(ApplicationCategory category, Application application) {
        String categoryName;
        ContentRegistry registry = this.getContentRegistry();
        CategoryDefinition categoryDef = registry.getCategory(categoryName = category.getName());
        if (categoryDef == null) {
            categoryDef = registry.createCategory(categoryName);
            this.save(category, categoryDef);
        }
        ContentDefinition contentDef = null;
        CategoryDefinition applicationCategoryDef = registry.getCategory(application.getCategoryName());
        String applicationName = application.getApplicationName();
        if (applicationCategoryDef != null) {
            contentDef = applicationCategoryDef.getContentMap().get(applicationName);
        }
        if (contentDef == null) {
            String contentId = application.getContentId();
            ContentType contentType = application.getType().getContentType();
            String definitionName = application.getApplicationName();
            contentDef = categoryDef.createContent(definitionName, contentType, contentId);
        } else {
            categoryDef.getContentList().add(contentDef);
        }
        this.save(application, contentDef);
    }

    @Override
    public void update(Application application) {
        String categoryName;
        ContentRegistry registry = this.getContentRegistry();
        CategoryDefinition categoryDef = registry.getCategory(categoryName = application.getCategoryName());
        if (categoryDef == null) {
            throw new IllegalStateException();
        }
        ContentDefinition contentDef = categoryDef.getContentMap().get(application.getApplicationName());
        if (contentDef == null) {
            throw new IllegalStateException();
        }
        this.save(application, contentDef);
    }

    @Override
    public void remove(Application app) {
        String categoryName;
        if (app == null) {
            throw new NullPointerException();
        }
        ContentRegistry registry = this.getContentRegistry();
        CategoryDefinition categoryDef = registry.getCategory(categoryName = app.getCategoryName());
        if (categoryDef != null) {
            String contentName = app.getApplicationName();
            categoryDef.getContentMap().remove(contentName);
        }
    }

    @Override
    public void importExoGadgets() throws Exception {
        ContentRegistry registry = this.getContentRegistry();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        GadgetRegistryService gadgetService = (GadgetRegistryService)container.getComponentInstanceOfType(GadgetRegistryService.class);
        List<Gadget> eXoGadgets = gadgetService.getAllGadgets();
        if (eXoGadgets != null) {
            ArrayList<String> permissions = new ArrayList<String>();
            permissions.add("Everyone");
            String categoryName = "Gadgets";
            CategoryDefinition category = registry.getCategory(categoryName);
            if (category == null) {
                category = registry.createCategory(categoryName);
                category.setDisplayName(categoryName);
                category.setDescription(categoryName);
                category.setAccessPermissions(permissions);
            }
            for (Gadget ele : eXoGadgets) {
                ContentDefinition app = category.getContentMap().get(ele.getName());
                if (app != null) continue;
                app = category.createContent(ele.getName(), org.exoplatform.portal.pom.spi.gadget.Gadget.CONTENT_TYPE, ele.getName());
                app.setDisplayName(ele.getTitle());
                app.setDescription(ele.getDescription());
                app.setAccessPermissions(permissions);
            }
        }
    }

    @Override
    public void importAllPortlets() throws Exception {
        ContentRegistry registry = this.getContentRegistry();
        this.log.info((Object)"About to import portlets in application registry");
        ExoContainer manager = ExoContainerContext.getCurrentContainer();
        PortletInvoker portletInvoker = (PortletInvoker)manager.getComponentInstance(PortletInvoker.class);
        Set portlets = portletInvoker.getPortlets();
        block0: for (Portlet portlet : portlets) {
            boolean remote;
            String keywords;
            PortletInfo info = portlet.getInfo();
            String portletApplicationName = info.getApplicationName();
            String portletName = portlet.getContext().getId();
            portletApplicationName = portletApplicationName.replace('/', '_');
            portletName = portletName.replace('/', '_');
            MetaInfo metaInfo = portlet.getInfo().getMeta();
            LocalizedString keywordsLS = metaInfo.getMetaValue("keywords");
            HashSet<String> categoryNames = new HashSet<String>();
            if (keywordsLS != null && (keywords = keywordsLS.getDefaultString()) != null && keywords.length() != 0) {
                for (String categoryName : keywords.split(",")) {
                    if (INTERNAL_PORTLET_TAG.equalsIgnoreCase(categoryName = categoryName.trim())) {
                        this.log.debug((Object)("Skipping portlet (" + portletApplicationName + "," + portletName + ") + tagged as internal"));
                        continue block0;
                    }
                    categoryNames.add(categoryName);
                }
            }
            ArrayList<String> permissions = new ArrayList<String>();
            permissions.add("Everyone");
            if (categoryNames.isEmpty()) {
                categoryNames.add(portletApplicationName.trim());
            }
            if (remote = portlet.isRemote()) {
                categoryNames.add(REMOTE_CATEGORY_NAME);
                LocalizedString producerNameLS = metaInfo.getMetaValue(PRODUCER_NAME_META_INFO_KEY);
                if (producerNameLS != null) {
                    categoryNames.add(producerNameLS.getDefaultString() + PRODUCER_CATEGORY_NAME_SUFFIX);
                }
            }
            this.log.info((Object)("Importing portlet (" + portletApplicationName + "," + portletName + ") in categories " + categoryNames));
            for (String categoryName : categoryNames) {
                String contentId;
                ContentType contentType;
                ContentDefinition app;
                CategoryDefinition category = registry.getCategory(categoryName);
                if (category == null) {
                    category = registry.createCategory(categoryName);
                    category.setDisplayName(categoryName);
                    category.setAccessPermissions(permissions);
                }
                if ((app = category.getContentMap().get(portletName)) != null) continue;
                LocalizedString descriptionLS = metaInfo.getMetaValue("description");
                LocalizedString displayNameLS = metaInfo.getMetaValue("display-name");
                String displayName = this.getLocalizedStringValue(displayNameLS, portletName);
                if (remote) {
                    contentType = WSRP.CONTENT_TYPE;
                    contentId = portlet.getContext().getId();
                    displayName = displayName + " (remote)";
                } else {
                    contentType = org.exoplatform.portal.pom.spi.portlet.Portlet.CONTENT_TYPE;
                    contentId = info.getApplicationName() + "/" + info.getName();
                }
                List<Application> applications = this.load(category, new ApplicationType[0]).getApplications();
                boolean isExist = false;
                for (Application application : applications) {
                    if (!application.getContentId().equals(contentId)) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                app = category.createContent(portletName, contentType, contentId);
                app.setDisplayName(displayName);
                app.setDescription(this.getLocalizedStringValue(descriptionLS, portletName));
                app.setAccessPermissions(permissions);
            }
        }
    }

    private boolean isApplicationType(Application app, ApplicationType<?> ... appTypes) {
        if (appTypes == null || appTypes.length == 0) {
            return true;
        }
        for (ApplicationType<?> appType : appTypes) {
            if (!appType.equals((Object)app.getType())) continue;
            return true;
        }
        return false;
    }

    private void save(ApplicationCategory category, CategoryDefinition categoryDef) {
        categoryDef.setDisplayName(category.getDisplayName());
        categoryDef.setDescription(category.getDescription());
        categoryDef.setAccessPermissions(category.getAccessPermissions());
        categoryDef.setCreationDate(category.getCreatedDate());
        categoryDef.setLastModificationDate(category.getModifiedDate());
    }

    private ApplicationCategory load(CategoryDefinition categoryDef, ApplicationType<?> ... appTypes) {
        ApplicationCategory category = new ApplicationCategory();
        category.setName(categoryDef.getName());
        category.setDisplayName(categoryDef.getDisplayName());
        category.setDescription(categoryDef.getDescription());
        category.setAccessPermissions(new ArrayList<String>(categoryDef.getAccessPermissions()));
        category.setCreatedDate(categoryDef.getCreationDate());
        category.setModifiedDate(categoryDef.getLastModificationDate());
        for (ContentDefinition contentDef : categoryDef.getContentList()) {
            Application application = this.load(contentDef);
            if (!this.isApplicationType(application, appTypes)) continue;
            category.getApplications().add(application);
        }
        return category;
    }

    private void save(Application application, ContentDefinition contentDef) {
        contentDef.setDisplayName(application.getDisplayName());
        contentDef.setDescription(application.getDescription());
        contentDef.setAccessPermissions(application.getAccessPermissions());
        contentDef.setCreationDate(application.getCreatedDate());
        contentDef.setLastModificationDate(application.getModifiedDate());
    }

    private Application load(ContentDefinition contentDef) {
        Customization customization = contentDef.getCustomization();
        ContentType contentType = customization.getType();
        ApplicationType applicationType = ApplicationType.getType((ContentType)contentType);
        Application application = new Application();
        application.setId(contentDef.getCategory().getName() + "/" + contentDef.getName());
        application.setCategoryName(contentDef.getCategory().getName());
        application.setType(applicationType);
        application.setApplicationName(contentDef.getName());
        application.setIconURL(ApplicationRegistryServiceImpl.getApplicationIconURL(contentDef));
        application.setDisplayName(contentDef.getDisplayName());
        application.setDescription(contentDef.getDescription());
        application.setAccessPermissions(new ArrayList<String>(contentDef.getAccessPermissions()));
        application.setCreatedDate(contentDef.getCreationDate());
        application.setModifiedDate(contentDef.getLastModificationDate());
        application.setStorageId(customization.getId());
        application.setContentId(customization.getContentId());
        return application;
    }

    private String getLocalizedStringValue(LocalizedString localizedString, String portletName) {
        if (localizedString == null || localizedString.getDefaultString() == null) {
            return portletName;
        }
        return localizedString.getDefaultString();
    }

    private static String getApplicationIconURL(ContentDefinition contentDef) {
        Customization customization = contentDef.getCustomization();
        if (customization != null) {
            ContentType type = customization.getType();
            String contentId = customization.getContentId();
            if (type == org.exoplatform.portal.pom.spi.portlet.Portlet.CONTENT_TYPE) {
                String[] chunks = contentId.split("/");
                if (chunks.length == 2) {
                    return "/" + chunks[0] + "/skin/DefaultSkin/portletIcons/" + chunks[1] + ".png";
                }
            } else {
                if (type == WSRP.CONTENT_TYPE) {
                    return "/eXoResources/skin/sharedImages/Icon80x80/DefaultPortlet.png";
                }
                if (type == org.exoplatform.portal.pom.spi.gadget.Gadget.CONTENT_TYPE) {
                    return "/eXoGadgets/skin/DefaultSkin/portletIcons/" + contentId + ".png";
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.plugins != null) {
            RequestLifeCycle.begin((ComponentRequestLifecycle)this.manager);
            boolean save = false;
            try {
                if (this.getApplicationCategories().size() < 1) {
                    for (ApplicationCategoriesPlugins plugin : this.plugins) {
                        plugin.run();
                    }
                }
                save = true;
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                this.manager.getSynchronization().setSaveOnClose(save);
                RequestLifeCycle.end();
            }
        }
    }

    public void stop() {
    }
}

