/*
 * Decompiled with CFR 0.152.
 */
package org.josso.servlet.agent;

import java.security.Principal;
import javax.security.auth.Subject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.agent.SSOAgentRequest;
import org.josso.agent.SingleSignOnEntry;
import org.josso.agent.http.JOSSOSecurityContext;
import org.josso.agent.http.JaasHttpSSOAgent;
import org.josso.gateway.identity.SSORole;
import org.josso.servlet.agent.GenericServletLocalSession;
import org.josso.servlet.agent.GenericServletSSOAgentRequest;

public class GenericServletSSOAgent
extends JaasHttpSSOAgent {
    private static final Log log = LogFactory.getLog(GenericServletSSOAgent.class);

    protected SingleSignOnEntry execute(SSOAgentRequest request) {
        GenericServletSSOAgentRequest r = (GenericServletSSOAgentRequest)request;
        GenericServletLocalSession localSession = (GenericServletLocalSession)r.getLocalSession();
        SingleSignOnEntry entry = super.execute(request);
        if (entry != null) {
            if (r.getSecurityContext() != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Publishing JOSSO Security Context instance in session [" + (entry != null ? entry.ssoId : "<NO-SSO-ID>") + "]"));
                }
                localSession.setSecurityContext(r.getSecurityContext());
            }
        } else if (localSession != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Clearing JOSSO Security Context for session [" + localSession.getId() + "]"));
            }
            localSession.setSecurityContext(null);
            r.setSecurityContext(null);
        }
        return entry;
    }

    protected Principal authenticate(SSOAgentRequest request) {
        String ssoSessionId = request.getSessionId();
        Principal ssoUser = super.authenticate(request);
        if (ssoUser != null) {
            Subject subject = new Subject();
            subject.getPrincipals().add(ssoUser);
            SSORole[] ssoRolePrincipals = this.getRoleSets(request.getRequester(), ssoSessionId);
            for (int i = 0; i < ssoRolePrincipals.length; ++i) {
                subject.getPrincipals().add((Principal)ssoRolePrincipals[i]);
                log.debug((Object)("Added SSORole Principal to the Subject : " + ssoRolePrincipals[i]));
            }
            GenericServletSSOAgentRequest r = (GenericServletSSOAgentRequest)request;
            JOSSOSecurityContext ctx = new JOSSOSecurityContext(subject);
            r.setSecurityContext(ctx);
        }
        return ssoUser;
    }

    protected boolean isAuthenticationAlwaysRequired() {
        return true;
    }

    protected void log(String message) {
        log.debug((Object)message);
    }

    protected void log(String message, Throwable throwable) {
        log.debug((Object)message, throwable);
    }
}

