/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.views.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.event.MouseInputListener;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.views.AnnotationComponent;
import org.icepdf.core.views.DocumentViewController;
import org.icepdf.core.views.DocumentViewModel;
import org.icepdf.core.views.common.SelectionBoxHandler;
import org.icepdf.core.views.swing.AbstractPageViewComponent;
import org.icepdf.core.views.swing.AnnotationComponentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationHandler
extends SelectionBoxHandler
implements MouseInputListener {
    private static final Logger logger = Logger.getLogger(AnnotationHandler.class.toString());
    private AbstractPageViewComponent pageViewComponent;
    private DocumentViewController documentViewController;
    private DocumentViewModel documentViewModel;
    private boolean isDragged;
    private ArrayList<AnnotationComponent> annotations;
    private ArrayList<AnnotationComponentImpl> selectedAnnotations;

    public AnnotationHandler(AbstractPageViewComponent pageViewComponent, DocumentViewModel documentViewModel) {
        this.pageViewComponent = pageViewComponent;
        this.documentViewModel = documentViewModel;
        this.selectedAnnotations = new ArrayList();
        this.selectionBoxColour = Color.GRAY;
    }

    public void setDocumentViewController(DocumentViewController documentViewController) {
        this.documentViewController = documentViewController;
    }

    public void initializeAnnotationComponents(ArrayList<Annotation> annotations) {
        if (this.annotations == null && annotations != null) {
            this.annotations = new ArrayList(annotations.size());
            for (Annotation annotation : annotations) {
                if (annotation.getFlagInvisible() || annotation.getFlagHidden()) continue;
                AnnotationComponentImpl comp = new AnnotationComponentImpl(annotation, this.documentViewController, this.pageViewComponent, this.documentViewModel);
                this.pageViewComponent.add(comp);
                this.annotations.add(comp);
            }
        }
    }

    public AnnotationComponent addAnnotationComponent(Annotation annotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        if (!annotation.getFlagInvisible() && !annotation.getFlagHidden()) {
            AnnotationComponentImpl comp = new AnnotationComponentImpl(annotation, this.documentViewController, this.pageViewComponent, this.documentViewModel);
            this.pageViewComponent.add(comp);
            this.annotations.add(comp);
            this.documentViewController.clearSelectedAnnotations();
            return comp;
        }
        return null;
    }

    public void removeAnnotationComponent(AnnotationComponent annotation) {
        if (this.annotations == null) {
            return;
        }
        ((Component)((Object)annotation)).setVisible(false);
        this.documentViewController.assignSelectedAnnotation(null);
    }

    public void createNewLinkAnnotation() {
        if (this.documentViewModel.getViewToolMode() == 6 && this.documentViewController.getAnnotationCallback() != null) {
            this.documentViewController.getAnnotationCallback().newAnnotation(this.pageViewComponent, this.rectToDraw);
        }
    }

    public void addSelectedAnnotation(AnnotationComponentImpl annotationComponent) {
        this.selectedAnnotations.add(annotationComponent);
    }

    public void removeSelectedAnnotation(AnnotationComponentImpl annotationComponent) {
        this.selectedAnnotations.remove(annotationComponent);
    }

    public void clearSelectedList() {
        this.selectedAnnotations.clear();
        this.selectedAnnotations.trimToSize();
    }

    public boolean isMultipleSelect() {
        return this.selectedAnnotations.size() > 1;
    }

    public void moveSelectedAnnotations(int x, int y) {
    }

    public void resizeSelectedAnnotations(int width, int height) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.clearSelectedList();
        if (this.documentViewModel.getViewToolMode() == 5 || this.documentViewModel.getViewToolMode() == 6) {
            int x = e.getX();
            int y = e.getY();
            this.currentRect = new Rectangle(x, y, 0, 0);
            this.updateDrawableRect(this.pageViewComponent.getWidth(), this.pageViewComponent.getHeight());
            this.pageViewComponent.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.isDragged = true;
        if (this.documentViewModel.getViewToolMode() == 5 || this.documentViewModel.getViewToolMode() == 6) {
            this.updateSelectionSize(e, this.pageViewComponent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.updateSelectionSize(e, this.pageViewComponent);
        if (this.documentViewModel.getViewToolMode() == 5) {
            this.clearRectangle(this.pageViewComponent);
            this.pageViewComponent.repaint();
        } else if (this.documentViewModel.getViewToolMode() == 6 && this.isDragged) {
            this.createNewLinkAnnotation();
            this.clearRectangle(this.pageViewComponent);
            this.pageViewComponent.repaint();
        }
        this.isDragged = false;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void paintAnnotations(Graphics g) {
        Page currentPage = this.pageViewComponent.getPageLock(this);
        if (currentPage != null && currentPage.isInitiated() && this.annotations != null) {
            Graphics2D gg2 = (Graphics2D)g;
            AffineTransform prePaintTransform = gg2.getTransform();
            Color oldColor = gg2.getColor();
            Stroke oldStroke = gg2.getStroke();
            AffineTransform at = currentPage.getPageTransform(this.documentViewModel.getPageBoundary(), this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom());
            gg2.transform(at);
            boolean notSelectTool = this.documentViewModel.getViewToolMode() != 5;
            for (AnnotationComponent annotation : this.annotations) {
                if (!((Component)((Object)annotation)).isVisible()) continue;
                annotation.getAnnotation().render(gg2, 1, this.documentViewModel.getViewRotation(), this.documentViewModel.getViewZoom(), annotation.hasFocus() && notSelectTool);
            }
            gg2.setColor(oldColor);
            gg2.setStroke(oldStroke);
            gg2.setTransform(prePaintTransform);
        }
        this.pageViewComponent.releasePageLock(currentPage, this);
        if (this.documentViewModel.getViewToolMode() == 6) {
            this.paintSelectionBox(g);
        }
    }
}

