/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.service;

import java.io.Serializable;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.forum.service.UserProfile;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class CacheUserProfile {
    private static ExoCache<Serializable, UserProfile> getCache() {
        CacheService cacheService = (CacheService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CacheService.class);
        return cacheService.getCacheInstance("forum.UserProfiles");
    }

    public static void storeInCache(String userName, UserProfile userProfile) {
        ExoCache<Serializable, UserProfile> cache = CacheUserProfile.getCache();
        Serializable cacheKey = CacheUserProfile.getCacheKey(userName);
        cache.put(cacheKey, (Object)userProfile);
    }

    public static void removeInCache(String userName) {
        ExoCache<Serializable, UserProfile> cache = CacheUserProfile.getCache();
        Serializable cacheKey = CacheUserProfile.getCacheKey(userName);
        cache.remove(cacheKey);
    }

    public static void clearCache() {
        ExoCache<Serializable, UserProfile> cache = CacheUserProfile.getCache();
        cache.clearCache();
    }

    public static UserProfile getFromCache(String userName) {
        if (Utils.isEmpty(userName) || "user_gest_uoom".equals(userName)) {
            return null;
        }
        ExoCache<Serializable, UserProfile> cache = CacheUserProfile.getCache();
        Serializable cacheKey = CacheUserProfile.getCacheKey(userName);
        return (UserProfile)cache.get(cacheKey);
    }

    private static Serializable getCacheKey(String userName) {
        return userName;
    }
}

