/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.common.rest.services.SuggestSpacesPortlet;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.RuntimeDelegate;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.RuntimeDelegateImpl;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/homepage/intranet/spaces/")
@Produces(value={"application/json"})
public class SpaceRestServices
implements ResourceContainer {
    private static Log log = ExoLogger.getLogger(SpaceRestServices.class);
    private static final CacheControl cacheControl;

    @GET
    @Path(value="suggestions")
    public Response getSuggestions(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
            List suggestedSpaces = spaceService.getPublicSpaces(userId);
            IdentityManager identityManager = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
            Identity identity = identityManager.getOrCreateIdentity("organization", userId);
            List connections = identityManager.getConnections(identity);
            JSONArray jsonArray = new JSONArray();
            JSONObject jsonGlobal = new JSONObject();
            for (Space space : suggestedSpaces) {
                if (space.getVisibility().equals("hidden") || space.getRegistration().equals("close")) continue;
                ArrayList<Identity> identityListMember = new ArrayList<Identity>();
                String avatar = space.getAvatarUrl();
                if (avatar == null) {
                    avatar = "/social-resources/skin/images/ShareImages/UserAvtDefault.png";
                }
                for (String mem : space.getMembers()) {
                    Identity identityMem = identityManager.getOrCreateIdentity("organization", mem);
                    identityListMember.add(identityMem);
                }
                int k = 0;
                for (Identity i : identityListMember) {
                    for (Identity j : connections) {
                        if (!j.equals((Object)i)) continue;
                        ++k;
                    }
                }
                String spaceType = "";
                spaceType = space.getRegistration().equals("open") ? "Public" : "Private";
                JSONObject json = new JSONObject();
                json.put("name", (Object)space.getName());
                json.put("spaceId", (Object)space.getId());
                json.put("displayName", (Object)space.getDisplayName());
                json.put("spaceUrl", (Object)space.getUrl());
                json.put("avatarUrl", (Object)avatar);
                json.put("registration", (Object)space.getRegistration());
                json.put("members", space.getMembers().length);
                json.put("privacy", (Object)spaceType);
                json.put("number", k);
                json.put("createdDate", space.getCreatedTime());
                jsonArray.put((Object)json);
            }
            jsonGlobal.put("items", (Object)jsonArray);
            jsonGlobal.put("noConnections", connections.size());
            return Response.ok((Object)jsonGlobal.toString(), (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in space invitation rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="accept/{spaceName}")
    public Response accept(@PathParam(value="spaceName") String spaceName, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
            if (spaceService.isInvitedUser(spaceService.getSpaceById(spaceName), userId)) {
                spaceService.addMember(spaceService.getSpaceById(spaceName), userId);
            }
            return Response.ok((Object)"{}", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in space accept rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="deny/{spaceName}")
    public Response deny(@PathParam(value="spaceName") String spaceName, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
            spaceService.removeInvitedUser(spaceService.getSpaceById(spaceName), userId);
            return Response.ok((Object)"{}", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in space deny rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="request/{spaceName}")
    public Response request(@PathParam(value="spaceName") String spaceName, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
            spaceService.addPendingUser(spaceService.getSpaceById(spaceName), userId);
            return Response.ok((Object)"{}", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in space deny rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="join/{spaceName}")
    public Response join(@PathParam(value="spaceName") String spaceName, @Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
            if (spaceService.getSpaceById(spaceName).getRegistration().equals("open")) {
                spaceService.addMember(spaceService.getSpaceById(spaceName), userId);
            }
            return Response.ok((Object)"{}", (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in space deny rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="myspaces")
    public Response request(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
            List mySpaces = spaceService.getAccessibleSpaces(userId);
            JSONArray jsonArray = new JSONArray();
            for (Space space : mySpaces) {
                JSONObject json = new JSONObject();
                json.put("name", (Object)space.getName());
                json.put("spaceId", (Object)space.getId());
                json.put("displayName", (Object)space.getDisplayName());
                json.put("spaceUrl", (Object)space.getUrl());
                json.put("members", space.getMembers().length);
                jsonArray.put((Object)json);
            }
            return Response.ok((Object)jsonArray.toString(), (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in space deny rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    @GET
    @Path(value="public")
    public Response getPublicSpaces(@Context SecurityContext sc, @Context UriInfo uriInfo) {
        try {
            String userId = this.getUserId(sc, uriInfo);
            if (userId == null) {
                return Response.status((int)500).cacheControl(cacheControl).build();
            }
            SpaceService spaceService = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
            ListAccess publicSpaces = spaceService.getPublicSpacesWithListAccess(userId);
            JSONArray jsonArray = new JSONArray();
            Space[] spaces = (Space[])publicSpaces.load(0, publicSpaces.getSize());
            if (spaces != null && spaces.length > 0) {
                for (Space space : spaces) {
                    if (space.getVisibility().equals("hidden") || space.getRegistration().equals("close")) continue;
                    JSONObject json = new JSONObject();
                    json.put("name", (Object)space.getName());
                    json.put("displayName", (Object)space.getDisplayName());
                    json.put("spaceId", (Object)space.getId());
                    jsonArray.put((Object)json);
                }
            }
            return Response.ok((Object)jsonArray.toString(), (String)"application/json").cacheControl(cacheControl).build();
        }
        catch (Exception e) {
            log.error((Object)("Error in space invitation rest service: " + e.getMessage()), (Throwable)e);
            return Response.ok((Object)"error").cacheControl(cacheControl).build();
        }
    }

    private String getUserId(SecurityContext sc, UriInfo uriInfo) {
        try {
            return sc.getUserPrincipal().getName();
        }
        catch (NullPointerException e) {
            return this.getViewerId(uriInfo);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getViewerId(UriInfo uriInfo) {
        String[] queryParts;
        URI uri = uriInfo.getRequestUri();
        String requestString = uri.getQuery();
        if (requestString == null) {
            return null;
        }
        for (String queryPart : queryParts = requestString.split("&")) {
            if (!queryPart.startsWith("opensocial_viewer_id")) continue;
            return queryPart.substring(queryPart.indexOf("=") + 1, queryPart.length());
        }
        return null;
    }

    static {
        RuntimeDelegate.setInstance((RuntimeDelegate)new RuntimeDelegateImpl());
        cacheControl = new CacheControl();
        cacheControl.setNoCache(true);
        cacheControl.setNoStore(true);
    }
}

