/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.lifecycle;

import org.chromattic.api.ChromatticSession;
import org.exoplatform.commons.chromattic.ChromatticLifeCycle;
import org.exoplatform.commons.chromattic.SessionContext;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;

public class SocialChromatticLifeCycle
extends ChromatticLifeCycle {
    private static final ThreadLocal<ChromatticSession> session = new ThreadLocal();
    private final ThreadLocal providerRoot = new ThreadLocal();
    private final ThreadLocal spaceRoot = new ThreadLocal();
    public static final String SOCIAL_LIFECYCLE_NAME = "soc";

    public ChromatticSession getSession() {
        if (this.invalidSession()) {
            this.reCreateSession();
        }
        return session.get();
    }

    public SocialChromatticLifeCycle(InitParams params) {
        super(params);
    }

    protected void onOpenSession(SessionContext context) {
        session.set(context.getSession());
        super.onOpenSession(context);
    }

    protected void onCloseSession(SessionContext context) {
        super.onCloseSession(context);
        if (session.get() != null) {
            session.get().close();
        }
        session.remove();
        this.providerRoot.set(null);
        this.spaceRoot.set(null);
    }

    public ThreadLocal getProviderRoot() {
        if (this.invalidSession()) {
            this.reCreateSession();
        }
        return this.providerRoot;
    }

    public ThreadLocal getSpaceRoot() {
        if (this.invalidSession()) {
            this.reCreateSession();
        }
        return this.spaceRoot;
    }

    private boolean invalidSession() {
        boolean invalid;
        boolean bl = invalid = session.get() == null;
        if (invalid) {
            return invalid;
        }
        return !session.get().getJCRSession().isLive() || session.get().isClosed();
    }

    private void reCreateSession() {
        try {
            this.onOpenSession(this.openContext());
        }
        catch (IllegalStateException e) {
            this.closeContext(false);
            this.getManager().endRequest(false);
            this.getManager().startRequest((ExoContainer)PortalContainer.getInstance());
            session.set(this.getChromattic().openSession());
        }
    }
}

