/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.security.auth.login.LoginException;
import org.jboss.crypto.digest.DigestCallback;
import org.jboss.logging.Logger;
import org.jboss.security.Base64Encoder;
import org.jboss.security.Base64Utils;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.auth.spi.DbUtil;
import org.jboss.security.auth.spi.SecurityActions;

public class Util {
    private static Logger log = Logger.getLogger(Util.class);
    public static final String BASE64_ENCODING = "BASE64";
    public static final String BASE16_ENCODING = "HEX";
    public static final String RFC2617_ENCODING = "RFC2617";
    private static char[] MD5_HEX = "0123456789abcdef".toCharArray();

    static Group[] getRoleSets(String targetUser, Properties roles, char roleGroupSeperator, AbstractServerLoginModule aslm) {
        Logger log = aslm.log;
        boolean trace = log.isTraceEnabled();
        Enumeration<?> users = roles.propertyNames();
        SimpleGroup rolesGroup = new SimpleGroup("Roles");
        ArrayList<SimpleGroup> groups = new ArrayList<SimpleGroup>();
        groups.add(rolesGroup);
        while (users.hasMoreElements() && targetUser != null) {
            String user = (String)users.nextElement();
            String value = roles.getProperty(user);
            if (trace) {
                log.trace((Object)("Checking user: " + user + ", roles string: " + value));
            }
            int index = user.indexOf(roleGroupSeperator, targetUser.length());
            boolean isRoleGroup = false;
            boolean userMatch = false;
            if (index > 0 && targetUser.regionMatches(0, user, 0, index)) {
                isRoleGroup = true;
            } else {
                userMatch = targetUser.equals(user);
            }
            if (isRoleGroup) {
                String groupName = user.substring(index + 1);
                if (groupName.equals("Roles")) {
                    if (trace) {
                        log.trace((Object)("Adding to Roles: " + value));
                    }
                    Util.parseGroupMembers(rolesGroup, value, aslm);
                    continue;
                }
                if (trace) {
                    log.trace((Object)("Adding to " + groupName + ": " + value));
                }
                SimpleGroup group = new SimpleGroup(groupName);
                Util.parseGroupMembers(group, value, aslm);
                groups.add(group);
                continue;
            }
            if (!userMatch) continue;
            if (trace) {
                log.trace((Object)("Adding to Roles: " + value));
            }
            Util.parseGroupMembers(rolesGroup, value, aslm);
        }
        Group[] roleSets = new Group[groups.size()];
        groups.toArray(roleSets);
        return roleSets;
    }

    static Group[] getRoleSets(String username, String dsJndiName, String rolesQuery, AbstractServerLoginModule aslm) throws LoginException {
        return Util.getRoleSets(username, dsJndiName, rolesQuery, aslm, false);
    }

    static Group[] getRoleSets(String username, String dsJndiName, String rolesQuery, AbstractServerLoginModule aslm, boolean suspendResume) throws LoginException {
        return DbUtil.getRoleSets(username, dsJndiName, rolesQuery, aslm, suspendResume);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadProperties(String defaultsName, String propertiesName, Logger log) throws IOException {
        InputStream is;
        URL url;
        URL defaultUrl;
        Properties bundle;
        boolean trace;
        block31: {
            File tmp;
            ClassLoader loader;
            block30: {
                trace = log.isTraceEnabled();
                bundle = null;
                loader = SecurityActions.getContextClassLoader();
                defaultUrl = null;
                url = null;
                if (loader instanceof URLClassLoader) {
                    URLClassLoader ucl = (URLClassLoader)loader;
                    defaultUrl = SecurityActions.findResource(ucl, defaultsName);
                    url = SecurityActions.findResource(ucl, propertiesName);
                    if (trace) {
                        log.trace((Object)("findResource: " + url));
                    }
                }
                if (defaultUrl == null && (defaultUrl = loader.getResource(defaultsName)) == null) {
                    try {
                        defaultUrl = new URL(defaultsName);
                    }
                    catch (MalformedURLException mue) {
                        if (trace) {
                            log.trace((Object)"Failed to open default properties as URL", (Throwable)mue);
                        }
                        if (!(tmp = new File(defaultsName)).exists()) break block30;
                        defaultUrl = tmp.toURI().toURL();
                    }
                }
            }
            if (url == null && (url = loader.getResource(propertiesName)) == null) {
                try {
                    url = new URL(propertiesName);
                }
                catch (MalformedURLException mue) {
                    if (trace) {
                        log.trace((Object)"Failed to open properties as URL", (Throwable)mue);
                    }
                    if (!(tmp = new File(propertiesName)).exists()) break block31;
                    url = tmp.toURI().toURL();
                }
            }
        }
        if (url == null && defaultUrl == null) {
            String msg = "No properties file: " + propertiesName + " or defaults: " + defaultsName + " found";
            throw new IOException(msg);
        }
        if (trace) {
            log.trace((Object)("Properties file=" + url + ", defaults=" + defaultUrl));
        }
        Properties defaults = new Properties();
        if (defaultUrl != null) {
            is = null;
            try {
                is = defaultUrl.openStream();
                defaults.load(is);
                if (trace) {
                    log.trace((Object)("Loaded defaults, users=" + defaults.keySet()));
                }
            }
            catch (Throwable e) {
                if (trace) {
                    log.trace((Object)"Failed to load defaults", e);
                }
            }
            finally {
                Util.safeClose(is);
            }
        }
        bundle = new Properties(defaults);
        if (url != null) {
            is = null;
            try {
                is = SecurityActions.openStream(url);
            }
            catch (PrivilegedActionException e) {
                if (trace) {
                    log.trace((Object)"Open stream error", (Throwable)e);
                }
                throw new IOException(e.getLocalizedMessage());
            }
            if (is != null) {
                try {
                    bundle.load(is);
                }
                finally {
                    Util.safeClose(is);
                }
            } else {
                throw new IOException("PB00015: Null Value:Properties file " + propertiesName + " not available");
            }
            if (trace) {
                log.trace((Object)("Loaded properties, users=" + bundle.keySet()));
            }
        }
        return bundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadProperties(String propertiesName, Logger log) throws IOException {
        URL url;
        Properties bundle;
        boolean trace;
        block18: {
            trace = log.isTraceEnabled();
            bundle = null;
            ClassLoader loader = SecurityActions.getContextClassLoader();
            url = null;
            if (loader instanceof URLClassLoader) {
                URLClassLoader ucl = (URLClassLoader)loader;
                url = SecurityActions.findResource(ucl, propertiesName);
                if (trace) {
                    log.trace((Object)("findResource: " + url));
                }
            }
            if (url == null && (url = loader.getResource(propertiesName)) == null) {
                try {
                    url = new URL(propertiesName);
                }
                catch (MalformedURLException mue) {
                    File tmp;
                    if (trace) {
                        log.trace((Object)"Failed to open properties as URL", (Throwable)mue);
                    }
                    if (!(tmp = new File(propertiesName)).exists()) break block18;
                    url = tmp.toURI().toURL();
                }
            }
        }
        if (url == null) {
            String msg = "No properties file: " + propertiesName + " found";
            throw new IOException(msg);
        }
        if (trace) {
            log.trace((Object)("Properties file=" + url));
        }
        Properties defaults = new Properties();
        bundle = new Properties(defaults);
        if (url != null) {
            InputStream is = null;
            try {
                is = SecurityActions.openStream(url);
            }
            catch (PrivilegedActionException e) {
                if (trace) {
                    log.trace((Object)"Open stream error", (Throwable)e);
                }
                throw new IOException(e.getLocalizedMessage());
            }
            if (is != null) {
                try {
                    bundle.load(is);
                }
                finally {
                    Util.safeClose(is);
                }
            } else {
                throw new IOException("PB00015: Null Value:Properties file " + propertiesName + " not available");
            }
            if (trace) {
                log.trace((Object)("Loaded properties, users=" + bundle.keySet()));
            }
        }
        return bundle;
    }

    static void parseGroupMembers(Group group, String roles, AbstractServerLoginModule aslm) {
        StringTokenizer tokenizer = new StringTokenizer(roles, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            try {
                Principal p = aslm.createIdentity(token);
                group.addMember(p);
            }
            catch (Exception e) {
                aslm.log.warn((Object)("Failed to create principal for: " + token), (Throwable)e);
            }
        }
    }

    public static String createPasswordHash(String hashAlgorithm, String hashEncoding, String hashCharset, String username, String password) {
        return Util.createPasswordHash(hashAlgorithm, hashEncoding, hashCharset, username, password, null);
    }

    public static String createPasswordHash(String hashAlgorithm, String hashEncoding, String hashCharset, String username, String password, DigestCallback callback) {
        byte[] passBytes;
        String passwordHash = null;
        try {
            passBytes = hashCharset == null ? password.getBytes() : password.getBytes(hashCharset);
        }
        catch (UnsupportedEncodingException uee) {
            log.error((Object)("charset " + hashCharset + " not found. Using platform default."), (Throwable)uee);
            passBytes = password.getBytes();
        }
        try {
            MessageDigest md = MessageDigest.getInstance(hashAlgorithm);
            if (callback != null) {
                callback.preDigest(md);
            }
            md.update(passBytes);
            if (callback != null) {
                callback.postDigest(md);
            }
            byte[] hash = md.digest();
            if (hashEncoding.equalsIgnoreCase(BASE64_ENCODING)) {
                passwordHash = Util.encodeBase64(hash);
            } else if (hashEncoding.equalsIgnoreCase(BASE16_ENCODING)) {
                passwordHash = Util.encodeBase16(hash);
            } else if (hashEncoding.equalsIgnoreCase(RFC2617_ENCODING)) {
                passwordHash = Util.encodeRFC2617(hash);
            } else {
                log.error((Object)("Unsupported hash encoding format " + hashEncoding));
            }
        }
        catch (Exception e) {
            log.error((Object)"Password hash calculation failed ", (Throwable)e);
        }
        return passwordHash;
    }

    public static String encodeRFC2617(byte[] data) {
        char[] hash = new char[32];
        for (int i = 0; i < 16; ++i) {
            int j = data[i] >> 4 & 0xF;
            hash[i * 2] = MD5_HEX[j];
            j = data[i] & 0xF;
            hash[i * 2 + 1] = MD5_HEX[j];
        }
        return new String(hash);
    }

    public static String encodeBase16(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            char c = (char)(b >> 4 & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
            c = (char)(b & 0xF);
            c = c > '\t' ? (char)(c - 10 + 97) : (char)(c + 48);
            sb.append(c);
        }
        return sb.toString();
    }

    public static String encodeBase64(byte[] bytes) {
        String base64 = null;
        try {
            base64 = Base64Encoder.encode(bytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return base64;
    }

    public static String tob64(byte[] buffer) {
        return Base64Utils.tob64(buffer);
    }

    public static byte[] fromb64(String str) throws NumberFormatException {
        return Base64Utils.fromb64(str);
    }

    private static void safeClose(InputStream fis) {
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

