/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.Map;
import org.jboss.cache.DataContainer;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.read.GetKeyValueCommand;
import org.jboss.cache.commands.write.EvictCommand;
import org.jboss.cache.commands.write.PutDataMapCommand;
import org.jboss.cache.commands.write.PutForExternalReadCommand;
import org.jboss.cache.commands.write.PutKeyValueCommand;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.interceptors.base.JmxStatsCommandInterceptor;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.jmx.annotations.ManagedOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMgmtInterceptor
extends JmxStatsCommandInterceptor {
    private long hitTimes = 0L;
    private long missTimes = 0L;
    private long storeTimes = 0L;
    private long hits = 0L;
    private long misses = 0L;
    private long stores = 0L;
    private long evictions = 0L;
    private long start;
    private long reset = this.start = System.currentTimeMillis();
    private DataContainer dataContainer;

    @Inject
    public void setDependencies(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }

    @Override
    public Object visitEvictFqnCommand(InvocationContext ctx, EvictCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, command);
        ++this.evictions;
        return returnValue;
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        long t1 = System.currentTimeMillis();
        Object retval = this.invokeNextInterceptor(ctx, command);
        long t2 = System.currentTimeMillis();
        if (retval == null) {
            this.missTimes += t2 - t1;
            ++this.misses;
        } else {
            this.hitTimes += t2 - t1;
            ++this.hits;
        }
        return retval;
    }

    @Override
    public Object visitPutDataMapCommand(InvocationContext ctx, PutDataMapCommand command) throws Throwable {
        Map data = command.getData();
        long t1 = System.currentTimeMillis();
        Object retval = this.invokeNextInterceptor(ctx, command);
        long t2 = System.currentTimeMillis();
        if (data != null && data.size() > 0) {
            this.storeTimes += t2 - t1;
            this.stores += (long)data.size();
        }
        return retval;
    }

    @Override
    public Object visitPutForExternalReadCommand(InvocationContext ctx, PutForExternalReadCommand command) throws Throwable {
        return this.visitPutKeyValueCommand(ctx, command);
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        long t1 = System.currentTimeMillis();
        Object retval = this.invokeNextInterceptor(ctx, command);
        long t2 = System.currentTimeMillis();
        this.storeTimes += t2 - t1;
        ++this.stores;
        return retval;
    }

    @ManagedAttribute(description="number of cache attribute hits")
    public long getHits() {
        return this.hits;
    }

    @ManagedAttribute(description="number of cache attribute misses")
    public long getMisses() {
        return this.misses;
    }

    @ManagedAttribute(description="number of cache attribute put operations")
    public long getStores() {
        return this.stores;
    }

    @ManagedAttribute(description="number of cache eviction operations")
    public long getEvictions() {
        return this.evictions;
    }

    @ManagedAttribute(description="hit/miss ratio for the cache")
    public double getHitMissRatio() {
        double total = this.hits + this.misses;
        if (total == 0.0) {
            return 0.0;
        }
        return (double)this.hits / total;
    }

    @ManagedAttribute(description="read/writes ratio for the cache")
    public double getReadWriteRatio() {
        if (this.stores == 0L) {
            return 0.0;
        }
        return (double)(this.hits + this.misses) / (double)this.stores;
    }

    @ManagedAttribute(description="average number of milliseconds for a read operation")
    public long getAverageReadTime() {
        long total = this.hits + this.misses;
        if (total == 0L) {
            return 0L;
        }
        return (this.hitTimes + this.missTimes) / total;
    }

    @ManagedAttribute(description="average number of milliseconds for a write operation")
    public long getAverageWriteTime() {
        if (this.stores == 0L) {
            return 0L;
        }
        return this.storeTimes / this.stores;
    }

    @ManagedAttribute(description="number of cache attributes")
    public int getNumberOfAttributes() {
        return this.dataContainer.getNumberOfAttributes();
    }

    @ManagedAttribute(description="number of nodes in the cache")
    public int getNumberOfNodes() {
        return this.dataContainer.getNumberOfNodes();
    }

    @ManagedAttribute(description="seconds since cache started")
    public long getElapsedTime() {
        return (System.currentTimeMillis() - this.start) / 1000L;
    }

    @ManagedAttribute(description="number of seconds since the cache statistics were last reset")
    public long getTimeSinceReset() {
        return (System.currentTimeMillis() - this.reset) / 1000L;
    }

    @Override
    @ManagedOperation
    public Map<String, Object> dumpStatistics() {
        HashMap<String, Object> retval = new HashMap<String, Object>();
        retval.put("Hits", this.hits);
        retval.put("Misses", this.misses);
        retval.put("Stores", this.stores);
        retval.put("Evictions", this.evictions);
        retval.put("NumberOfAttributes", this.dataContainer.getNumberOfAttributes());
        retval.put("NumberOfNodes", this.dataContainer.getNumberOfNodes());
        retval.put("ElapsedTime", this.getElapsedTime());
        retval.put("TimeSinceReset", this.getTimeSinceReset());
        retval.put("AverageReadTime", this.getAverageReadTime());
        retval.put("AverageWriteTime", this.getAverageWriteTime());
        retval.put("HitMissRatio", this.getHitMissRatio());
        retval.put("ReadWriteRatio", this.getReadWriteRatio());
        return retval;
    }

    @Override
    @ManagedOperation
    public void resetStatistics() {
        this.hits = 0L;
        this.misses = 0L;
        this.stores = 0L;
        this.evictions = 0L;
        this.hitTimes = 0L;
        this.missTimes = 0L;
        this.storeTimes = 0L;
        this.reset = System.currentTimeMillis();
    }
}

