/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jdbc;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.naming.InvalidNameException;
import org.exoplatform.services.database.DAO;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.DBObjectMapper;
import org.exoplatform.services.database.DBObjectQuery;
import org.exoplatform.services.database.DBPageList;
import org.exoplatform.services.database.ExoDatasource;
import org.exoplatform.services.database.StandardSQLDAO;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeEventListener;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.jdbc.MembershipTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipTypeDAOImpl
extends StandardSQLDAO<MembershipTypeImpl>
implements MembershipTypeHandler {
    protected ListenerService listenerService_;

    public MembershipTypeDAOImpl(ListenerService lService, ExoDatasource datasource, DBObjectMapper<MembershipTypeImpl> mapper) {
        super(datasource, mapper, MembershipTypeImpl.class);
        this.listenerService_ = lService;
    }

    public MembershipType createMembershipTypeInstance() {
        return new MembershipTypeImpl();
    }

    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        Date now = Calendar.getInstance().getTime();
        mt.setCreatedDate(now);
        mt.setModifiedDate(now);
        super.save((DBObject)((MembershipTypeImpl)mt));
        return mt;
    }

    public MembershipType findMembershipType(String name) throws Exception {
        DBObjectQuery query = new DBObjectQuery(MembershipTypeImpl.class);
        query.addEQ("MT_NAME", (Object)name);
        MembershipType mt = (MembershipType)this.loadUnique(query.toQuery());
        return mt;
    }

    public Collection<MembershipTypeImpl> findMembershipTypes() throws Exception {
        DBObjectQuery query = new DBObjectQuery(MembershipTypeImpl.class);
        DBPageList pageList = new DBPageList(20, (DAO)this, query);
        return pageList.getAll();
    }

    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        DBObjectQuery query = new DBObjectQuery(MembershipTypeImpl.class);
        query.addEQ("MT_NAME", (Object)name);
        MembershipTypeImpl mt = (MembershipTypeImpl)this.loadUnique(query.toQuery());
        if (mt == null) {
            throw new InvalidNameException("Can not remove membership type" + name + "record, because membership type does not exist.");
        }
        if (broadcast) {
            this.listenerService_.broadcast("organization.membershipType.preDelete", (Object)this, (Object)mt);
        }
        super.remove((DBObject)mt);
        if (broadcast) {
            this.listenerService_.broadcast("porganization.membershipType.postDelete", (Object)this, (Object)mt);
        }
        return mt;
    }

    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        mt.setModifiedDate(Calendar.getInstance().getTime());
        super.update((DBObject)((MembershipTypeImpl)mt));
        return mt;
    }

    public void addMembershipTypeEventListener(MembershipTypeEventListener listener) {
        throw new UnsupportedOperationException("This method is not supported anymore, please use the new api");
    }

    public void removeMembershipTypeEventListener(MembershipTypeEventListener listener) {
        throw new UnsupportedOperationException("This method is not supported anymore, please use the new api");
    }
}

