/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.forum.create;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.forum.common.CommonUtils;
import org.exoplatform.forum.common.UserHelper;
import org.exoplatform.forum.common.webui.BaseUIForm;
import org.exoplatform.forum.common.webui.UIFormScrollSelectBox;
import org.exoplatform.forum.common.webui.UIForumFilter;
import org.exoplatform.forum.create.CreateUtils;
import org.exoplatform.forum.service.Category;
import org.exoplatform.forum.service.Forum;
import org.exoplatform.forum.service.ForumService;
import org.exoplatform.forum.service.Utils;
import org.exoplatform.forum.service.filter.model.CategoryFilter;
import org.exoplatform.forum.service.filter.model.ForumFilter;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;

public class UICreateForm
extends BaseUIForm {
    public static final String LOCATION_SELECT_BOX = "location";
    public static final String FORUM_SELECT_BOX = "forumId";
    private static final String INTRANER = "intranet";
    public boolean isStepOne = true;
    public boolean hasForumIntranet = true;
    public boolean hasForum = true;
    public boolean hasNext = true;
    public String parStatus = "";
    public String categoryIdOfSpaces = "";
    public String currentIntranet = "intranet";
    public CategoryFilter onlyOneForum = null;
    public List<String> allPortalNames = new ArrayList<String>();

    public void setParStatus(String parStatus) {
        this.parStatus = parStatus;
    }

    public String getParStatus() {
        return this.parStatus;
    }

    public boolean hasForum() {
        return this.hasForum;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public UICreateForm() throws Exception {
        Category categoryIncludedSpace;
        this.currentIntranet = this.getIntranerSite();
        ArrayList<SelectItemOption> list = new ArrayList<SelectItemOption>();
        this.allPortalNames = CreateUtils.getAllPortalNames();
        String currentUser = UserHelper.getCurrentUser();
        ForumService forumService = (ForumService)this.getApplicationComponent(ForumService.class);
        List filters = forumService.filterForumByName("_", currentUser, 2);
        int categoriesSize = filters.size();
        if (categoriesSize == 1 && ((CategoryFilter)filters.get(0)).getForumFilters().size() == 1) {
            this.onlyOneForum = (CategoryFilter)filters.get(0);
        }
        boolean bl = this.hasForumIntranet = categoriesSize > 0;
        if (this.hasForumIntranet) {
            list.add(new SelectItemOption(this.currentIntranet, (Object)this.currentIntranet));
        }
        if ((categoryIncludedSpace = forumService.getCategoryIncludedSpace()) != null) {
            this.categoryIdOfSpaces = categoryIncludedSpace.getId();
            List groupAndMembershipInfos = UserHelper.getAllGroupAndMembershipOfUser(null);
            StringBuilder strQuery = new StringBuilder();
            if (!forumService.isAdminRole((String)groupAndMembershipInfos.get(0))) {
                strQuery.append("(").append(Utils.buildXpathByUserInfo((String)"exo:createTopicRole", (List)groupAndMembershipInfos)).append(" or ").append(Utils.buildXpathByUserInfo((String)"exo:moderators", (List)groupAndMembershipInfos));
                strQuery.append(") and ");
            }
            strQuery.append(Utils.getQueryByProperty((String)"", (String)"exo:isClosed", (String)"false"));
            List forums = forumService.getForumSummaries(this.categoryIdOfSpaces, strQuery.toString());
            SpaceService spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
            List spaces = spaceService.getLastAccessedSpace(currentUser, null, 0, forums.size());
            for (Space space : spaces) {
                Forum forum = this.getForum(forums, space.getGroupId());
                if (forum == null) continue;
                list.add(new SelectItemOption(space.getDisplayName(), (Object)forum.getId()));
            }
        }
        if (list.size() > 0) {
            UIFormScrollSelectBox formSelectBox = new UIFormScrollSelectBox(LOCATION_SELECT_BOX, LOCATION_SELECT_BOX, list);
            if (this.hasForumIntranet) {
                formSelectBox.setValue(this.currentIntranet);
            }
            formSelectBox.setOnChange("OnChangeLocal");
            this.addUIFormInput((UIFormInput)formSelectBox);
            this.hasForum = true;
            this.setActions(new String[]{"Next", "Cancel"});
        } else {
            this.hasForum = false;
            this.setActions(new String[]{"Cancel"});
        }
    }

    private Forum getForum(List<Forum> forums, String spaceGroupId) {
        String spaceName = spaceGroupId.replaceAll("/spaces/", "");
        for (Forum forum : forums) {
            if (!forum.getId().equals(Utils.FORUM_SPACE_ID_PREFIX + spaceName)) continue;
            return forum;
        }
        return null;
    }

    public String getIntranerSite() {
        String portalName = CreateUtils.getCurrentPortalName();
        if (portalName.equalsIgnoreCase(SiteType.GROUP.name())) {
            return INTRANER;
        }
        return portalName;
    }

    public static void nextAction(UICreateForm uiForm, ACTION_TYPE type, WebuiRequestContext context) throws Exception {
        if (uiForm.isStepOne && uiForm.hasForumIntranet) {
            uiForm.isStepOne = false;
            if (uiForm.onlyOneForum == null) {
                UIForumFilter forumFilter = uiForm.getUIForumFilter(FORUM_SELECT_BOX);
                if (forumFilter == null) {
                    forumFilter = new UIForumFilter(FORUM_SELECT_BOX, FORUM_SELECT_BOX);
                    forumFilter.setOnChange("OnChangeFilter");
                    uiForm.addUIFormInput((UIFormInput)forumFilter);
                }
                forumFilter.setRendered(true);
                uiForm.hasNext = false;
                context.addUIComponentToUpdateByAjax((UIComponent)uiForm);
            } else {
                UICreateForm.nextAction(uiForm, type, context);
            }
        } else {
            String location = (String)uiForm.getUIFormScrollSelectBox(LOCATION_SELECT_BOX).getValue();
            String subUrl = null;
            if (uiForm.currentIntranet.equals(location)) {
                if (uiForm.onlyOneForum == null) {
                    UIForumFilter forumFilter = uiForm.getUIForumFilter(FORUM_SELECT_BOX);
                    String categoryId = forumFilter.getCategoryId();
                    String forumId = forumFilter.getForumId();
                    if (!CommonUtils.isEmpty((String)forumId)) {
                        subUrl = UICreateForm.urlBuilder(categoryId, forumId, type, location);
                    } else {
                        uiForm.warning("UICreateList.label.RequireSelectForum");
                    }
                } else {
                    String categoryId = uiForm.onlyOneForum.getCategoryId();
                    String forumId = ((ForumFilter)uiForm.onlyOneForum.getForumFilters().get(0)).getForumId();
                    subUrl = UICreateForm.urlBuilder(categoryId, forumId, type, location);
                    uiForm.onlyOneForum = null;
                }
            } else {
                subUrl = UICreateForm.urlBuilder(uiForm.categoryIdOfSpaces, location, type, null);
            }
            if (!CommonUtils.isEmpty((String)subUrl)) {
                uiForm.log.info((Object)(uiForm.getId() + "::sendRedirect =" + subUrl));
                PortalRequestContext pContext = Util.getPortalRequestContext();
                pContext.getJavascriptManager().getRequireJS().addScripts("(function(){ window.location.href = '" + subUrl + "';})();");
                uiForm.isStepOne = true;
                if (uiForm.getChildById(FORUM_SELECT_BOX) != null) {
                    uiForm.removeChildById(FORUM_SELECT_BOX);
                }
                context.addUIComponentToUpdateByAjax((UIComponent)uiForm);
                UIContainer container = (UIContainer)uiForm.getParent();
                List uilist = container.getChildren();
                ArrayList<String> lisID = new ArrayList<String>();
                if (uilist.size() != 0) {
                    for (UIComponent uIComponent : uilist) {
                        lisID.add(uIComponent.getId());
                    }
                    for (String id : lisID) {
                        container.removeChildById(id);
                    }
                }
                context.addUIComponentToUpdateByAjax((UIComponent)container);
            }
        }
    }

    private static String urlBuilder(String categoryId, String forumId, ACTION_TYPE type, String siteName) {
        String urlBuilder = CreateUtils.buildLink(categoryId, forumId, null, siteName);
        if (!CommonUtils.isEmpty((String)urlBuilder)) {
            String actionType = type.equals((Object)ACTION_TYPE.CREATE_TOPIC) ? "?hasCreateTopic=true" : "?hasCreatePoll=true";
            urlBuilder = urlBuilder + actionType;
        }
        return urlBuilder;
    }

    public static class CancelActionListener
    extends EventListener<UICreateForm> {
        public void execute(Event<UICreateForm> event) throws Exception {
            UICreateForm createForm = (UICreateForm)((Object)event.getSource());
            createForm.isStepOne = true;
            if (createForm.getChildById(UICreateForm.FORUM_SELECT_BOX) != null) {
                createForm.removeChildById(UICreateForm.FORUM_SELECT_BOX);
            }
            WebuiRequestContext ctx = event.getRequestContext();
            Event cancelEvent = createForm.getParent().createEvent("Cancel", Event.Phase.DECODE, ctx);
            if (cancelEvent != null) {
                cancelEvent.broadcast();
            }
        }
    }

    public static class OnChangeFilterActionListener
    extends EventListener<UICreateForm> {
        public void execute(Event<UICreateForm> event) throws Exception {
            UICreateForm createForm = (UICreateForm)((Object)event.getSource());
            createForm.isStepOne = false;
            createForm.hasNext = true;
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)createForm);
        }
    }

    public static enum ACTION_TYPE {
        CREATE_POLL,
        CREATE_TOPIC;

    }
}

