/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.binding.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.exoplatform.portal.config.model.I18NString;
import org.exoplatform.portal.config.model.LocalizedString;
import org.exoplatform.portal.config.model.NavigationFragment;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.mop.Visibility;
import org.exoplatform.portal.mop.management.binding.xml.Element;
import org.exoplatform.portal.mop.management.binding.xml.Utils;
import org.gatein.common.xml.stax.navigator.Exceptions;
import org.gatein.common.xml.stax.navigator.StaxNavUtils;
import org.gatein.common.xml.stax.writer.StaxWriter;
import org.gatein.common.xml.stax.writer.StaxWriterUtils;
import org.gatein.common.xml.stax.writer.WritableValueType;
import org.gatein.common.xml.stax.writer.WritableValueTypes;
import org.gatein.management.api.binding.BindingException;
import org.gatein.management.api.binding.Marshaller;
import org.staxnav.StaxNavException;
import org.staxnav.StaxNavigator;
import org.staxnav.ValueType;

public class NavigationMarshaller
implements Marshaller<PageNavigation> {
    public void marshal(PageNavigation navigation, OutputStream outputStream) throws BindingException {
        try {
            StaxWriter writer = StaxWriterUtils.createWriter(Element.class, (OutputStream)outputStream);
            this.marshalNavigation((StaxWriter<Element>)writer, navigation);
        }
        catch (StaxNavException e) {
            throw new BindingException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new BindingException((Throwable)e);
        }
    }

    public PageNavigation unmarshal(InputStream is) throws BindingException {
        try {
            StaxNavigator navigator = StaxNavUtils.createNavigator(Element.class, (Enum)Element.UNKNOWN, (InputStream)is);
            return this.unmarshalNavigation((StaxNavigator<Element>)navigator);
        }
        catch (StaxNavException e) {
            throw new BindingException((Throwable)e);
        }
    }

    private void marshalNavigation(StaxWriter<Element> writer, PageNavigation navigation) throws XMLStreamException {
        writer.writeStartElement((Object)Element.NODE_NAVIGATION);
        Utils.writeGateinObjectsNamespace(writer);
        writer.writeElement((Object)Element.PRIORITY, WritableValueTypes.INTEGER, (Object)navigation.getPriority());
        ArrayList<NavigationFragment> fragments = navigation.getFragments();
        for (NavigationFragment fragment : fragments) {
            ArrayList<PageNode> nodes;
            writer.writeStartElement((Object)Element.PAGE_NODES);
            if (fragment.getParentURI() != null) {
                String parentUri = fragment.getParentURI();
                StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.PARENT_URI), (String)parentUri);
            }
            if ((nodes = fragment.getNodes()) != null && !nodes.isEmpty()) {
                for (PageNode node : nodes) {
                    this.marshallNode(writer, node);
                }
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    public void marshallNode(StaxWriter<Element> writer, PageNode node) throws XMLStreamException {
        writer.writeStartElement((Object)Element.NODE);
        writer.writeElement((Object)Element.NAME, node.getName());
        if (node.getLabels() != null) {
            for (LocalizedString label : node.getLabels()) {
                if (label.getValue() == null) continue;
                writer.writeStartElement((Object)Element.LABEL);
                if (label.getLang() != null) {
                    String localeString = label.getLang().getLanguage();
                    if (localeString == null) {
                        throw new XMLStreamException("Language was null for locale " + label.getLang());
                    }
                    String country = label.getLang().getCountry();
                    if (country != null && country.length() > 0) {
                        localeString = localeString + "-" + country.toLowerCase();
                    }
                    writer.writeAttribute(new QName("http://www.w3.org/XML/1998/namespace", "lang", "xml"), localeString);
                }
                writer.writeContent((String)label.getValue()).writeEndElement();
            }
        }
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.ICON), (String)node.getIcon());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.START_PUBLICATION_DATE), (WritableValueType)WritableValueTypes.DATE_TIME, (Object)node.getStartPublicationDate());
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.END_PUBLICATION_DATE), (WritableValueType)WritableValueTypes.DATE_TIME, (Object)node.getEndPublicationDate());
        String visibility = node.getVisibility() == null ? null : node.getVisibility().name();
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.VISIBILITY), (String)visibility);
        StaxWriterUtils.writeOptionalElement(writer, (Object)((Object)Element.PAGE_REFERENCE), (String)node.getPageReference());
        ArrayList<PageNode> children = node.getNodes();
        if (children != null && !children.isEmpty()) {
            for (PageNode child : children) {
                this.marshallNode(writer, child);
            }
        }
        writer.writeEndElement();
    }

    private PageNavigation unmarshalNavigation(StaxNavigator<Element> navigator) throws StaxNavException {
        PageNavigation navigation = new PageNavigation();
        if (navigator.getName() == Element.NODE_NAVIGATION) {
            Element next = (Element)((Object)navigator.child());
            if (next != Element.PRIORITY) {
                throw Exceptions.expectedElement(navigator, (Object)((Object)Element.PRIORITY));
            }
            Integer priority = (Integer)StaxNavUtils.parseRequiredContent(navigator, (ValueType)ValueType.INTEGER);
            navigation.setPriority(priority);
            next = (Element)((Object)navigator.sibling());
            if (next == Element.PAGE_NODES) {
                for (StaxNavigator fork : navigator.fork((Object)Element.PAGE_NODES)) {
                    NavigationFragment fragment = new NavigationFragment();
                    navigation.addFragment(fragment);
                    next = (Element)((Object)fork.child());
                    if (next == Element.PARENT_URI) {
                        String parentUri = fork.getContent();
                        if (parentUri == null) {
                            parentUri = "";
                        } else if (parentUri.charAt(0) == '/') {
                            parentUri = parentUri.substring(1, parentUri.length());
                        }
                        fragment.setParentURI(parentUri);
                        next = (Element)((Object)fork.sibling());
                    }
                    if (next == Element.NODE) {
                        ArrayList<PageNode> nodes = new ArrayList<PageNode>();
                        for (StaxNavigator nodeFork : fork.fork((Object)Element.NODE)) {
                            nodes.add(this.unmarshalNode((StaxNavigator<Element>)nodeFork));
                        }
                        fragment.setNodes(nodes);
                        continue;
                    }
                    if (next == null) continue;
                    throw Exceptions.unknownElement((StaxNavigator)fork);
                }
            } else if (next != null) {
                throw Exceptions.expectedElement(navigator, (Object)((Object)Element.PAGE_NODES));
            }
            return navigation;
        }
        throw Exceptions.unknownElement(navigator);
    }

    private PageNode unmarshalNode(StaxNavigator<Element> navigator) throws StaxNavException {
        PageNode node = new PageNode();
        I18NString labels = new I18NString();
        ArrayList<PageNode> children = new ArrayList<PageNode>();
        Element current = (Element)((Object)navigator.child());
        block12: while (current != null) {
            switch ((Element)((Object)navigator.getName())) {
                case URI: {
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case NAME: {
                    node.setName(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case LABEL: {
                    labels.add(Utils.parseLocalizedString(navigator));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case ICON: {
                    node.setIcon(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case START_PUBLICATION_DATE: {
                    node.setStartPublicationDate((Date)navigator.parseContent(ValueType.DATE_TIME));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case END_PUBLICATION_DATE: {
                    node.setEndPublicationDate((Date)navigator.parseContent(ValueType.DATE_TIME));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case VISIBILITY: {
                    node.setVisibility((Visibility)((Object)navigator.parseContent(ValueType.get(Visibility.class))));
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case PAGE_REFERENCE: {
                    node.setPageReference(navigator.getContent());
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case NODE: {
                    PageNode child = this.unmarshalNode((StaxNavigator<Element>)navigator.fork());
                    children.add(child);
                    current = (Element)((Object)navigator.sibling());
                    continue block12;
                }
                case UNKNOWN: {
                    throw Exceptions.unknownElement(navigator);
                }
            }
            throw Exceptions.unexpectedElement(navigator);
        }
        node.setLabels(labels);
        node.setChildren(children);
        return node;
    }
}

