/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.mop.management.exportimport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.management.exportimport.AbstractExportTask;
import org.exoplatform.portal.mop.management.operations.page.PageUtils;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageService;
import org.gatein.management.api.binding.Marshaller;
import org.gatein.management.api.operation.model.ExportTask;

public class PageExportTask
extends AbstractExportTask
implements ExportTask {
    public static final String FILE = "pages.xml";
    private final DataStorage dataStorage;
    private final PageService pageService;
    private final Marshaller<Page.PageSet> marshaller;
    private final List<String> pageNames;

    public PageExportTask(SiteKey siteKey, DataStorage dataStorage, PageService pageService, Marshaller<Page.PageSet> marshaller) {
        super(siteKey);
        this.dataStorage = dataStorage;
        this.pageService = pageService;
        this.marshaller = marshaller;
        this.pageNames = new ArrayList<String>();
    }

    public void export(OutputStream outputStream) throws IOException {
        Page.PageSet pages = new Page.PageSet();
        pages.setPages(new ArrayList<Page>(this.pageNames.size()));
        for (String pageName : this.pageNames) {
            try {
                PageKey pageKey = new PageKey(this.siteKey, pageName);
                pages.getPages().add(PageUtils.getPage(this.dataStorage, this.pageService, pageKey));
            }
            catch (Exception e) {
                throw new IOException("Could not retrieve page name " + pageName + " for site " + this.siteKey, e);
            }
        }
        this.marshaller.marshal((Object)pages, outputStream);
    }

    @Override
    protected String getXmlFileName() {
        return FILE;
    }

    public void addPageName(String pageName) {
        this.pageNames.add(pageName);
    }

    public List<String> getPageNames() {
        return Collections.unmodifiableList(this.pageNames);
    }
}

