/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.registration;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.organization.User;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;

public class PostRegistrationService {
    private final String mailFrom;
    private final String mailTo;
    private final String mailSubject;
    private final String mailMessage;
    private final MailService mailService;
    private final Boolean sendMailEnabled;
    private static final Logger log = LoggerFactory.getLogger(PostRegistrationService.class);

    public PostRegistrationService(InitParams params, MailService mailService) {
        this.mailService = mailService;
        this.sendMailEnabled = Boolean.valueOf(params.getValueParam("sendMailAfterRegistration").getValue());
        this.mailFrom = params.getValueParam("mailFrom").getValue();
        this.mailTo = params.getValueParam("mailTo").getValue();
        this.mailSubject = params.getValueParam("mailSubject").getValue();
        this.mailMessage = params.getValueParam("mailMessage").getValue();
    }

    public void sendMailAfterSuccessfulRegistration(User user) {
        if (!this.sendMailEnabled.booleanValue()) {
            log.debug((Object)("Sending of mails disabled. Mail won't be send about creating of user " + user.getUserName()));
            return;
        }
        try {
            String subject = this.replaceTokens(this.mailSubject, user);
            String message = this.replaceTokens(this.mailMessage, user);
            log.debug((Object)("Sending mail about the creating of user " + user.getUserName()));
            this.mailService.sendMessage(this.mailFrom, this.mailTo, subject, message);
        }
        catch (Exception e) {
            log.error((Object)("Error when sending mail to admin after registration of user " + user.getUserName()), (Throwable)e);
        }
    }

    private String replaceTokens(String param, User user) {
        String result = param.replaceAll("\\$\\{user.userName\\}", user.getUserName());
        result = result.replaceAll("\\$\\{user.firstName\\}", user.getFirstName());
        result = result.replaceAll("\\$\\{user.lastName\\}", user.getLastName());
        result = result.replaceAll("\\$\\{user.email\\}", user.getEmail());
        return result;
    }
}

