/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class MediaHeaderBox
extends AbstractFullBox {
    public static final String TYPE = "mdhd";
    private long creationTime;
    private long modificationTime;
    private long timescale;
    private long duration;
    private String language;

    public MediaHeaderBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getTimescale() {
        return this.timescale;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getLanguage() {
        return this.language;
    }

    protected long getContentSize() {
        long contentSize = 0L;
        contentSize = this.getVersion() == 1 ? (contentSize += 28L) : (contentSize += 16L);
        contentSize += 2L;
        return contentSize += 2L;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public void setModificationTime(long modificationTime) {
        this.modificationTime = modificationTime;
    }

    public void setTimescale(long timescale) {
        this.timescale = timescale;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        if (this.getVersion() == 1) {
            this.creationTime = in.readUInt64();
            this.modificationTime = in.readUInt64();
            this.timescale = in.readUInt32();
            this.duration = in.readUInt64();
        } else {
            this.creationTime = in.readUInt32();
            this.modificationTime = in.readUInt32();
            this.timescale = in.readUInt32();
            this.duration = in.readUInt32();
        }
        this.language = in.readIso639();
        in.readUInt16();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("MovieHeaderBox[");
        result.append("creationTime=").append(this.getCreationTime());
        result.append(";");
        result.append("modificationTime=").append(this.getModificationTime());
        result.append(";");
        result.append("timescale=").append(this.getTimescale());
        result.append(";");
        result.append("duration=").append(this.getDuration());
        result.append(";");
        result.append("language=").append(this.getLanguage());
        result.append("]");
        return result.toString();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        if (this.getVersion() == 1) {
            isos.writeUInt64(this.creationTime);
            isos.writeUInt64(this.modificationTime);
            isos.writeUInt32(this.timescale);
            isos.writeUInt64(this.duration);
        } else {
            isos.writeUInt32((int)this.creationTime);
            isos.writeUInt32((int)this.modificationTime);
            isos.writeUInt32((int)this.timescale);
            isos.writeUInt32((int)this.duration);
        }
        isos.writeIso639(this.language);
        isos.writeUInt16(0);
    }
}

