/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.document.impl.image;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import org.exoplatform.services.document.image.ImageProcessingService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ImageProcessingServiceImpl
implements ImageProcessingService {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.core.component.document.ImageProcessingServiceImpl");

    public BufferedImage createCroppedImage(BufferedImage img, int chosenWidth, int chosenHeight) {
        int topX = 0;
        int topY = 0;
        int newWidth = 0;
        int newHeight = 0;
        double factor = 0.0;
        double scaleHorizontalFactor = this.getScaleFactor(chosenWidth, img.getWidth());
        double scaleVerticalFactor = this.getScaleFactor(chosenHeight, img.getHeight());
        if (scaleVerticalFactor > scaleHorizontalFactor) {
            factor = scaleVerticalFactor;
            newWidth = (int)Math.round((double)img.getWidth() * factor);
            newHeight = (int)Math.round((double)img.getHeight() * factor);
            topX = (newWidth - chosenWidth) / 2;
        } else {
            factor = scaleHorizontalFactor;
            newWidth = (int)Math.round((double)img.getWidth() * factor);
            newHeight = (int)Math.round((double)img.getHeight() * factor);
            topY = (newHeight - chosenHeight) / 2;
        }
        BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D aImage = scaledImage.createGraphics();
        aImage.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        aImage.drawImage(img, 0, 0, newWidth, newHeight, null);
        BufferedImage croppedImage = scaledImage.getSubimage(topX, topY, chosenWidth, chosenHeight);
        BufferedImage imageBuf = new BufferedImage(chosenWidth, chosenHeight, 1);
        Graphics2D newImage = imageBuf.createGraphics();
        newImage.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        newImage.drawImage(croppedImage, 0, 0, chosenWidth, chosenHeight, null);
        return imageBuf;
    }

    public BufferedImage createBoundImage(BufferedImage img, int chosenWidth, int chosenHeight, String bgColor) {
        double factor = 0.0;
        double scaleHorizontalFactor = this.getScaleFactor(chosenWidth, img.getWidth());
        double scaleVerticalFactor = this.getScaleFactor(chosenHeight, img.getHeight());
        factor = scaleVerticalFactor > scaleHorizontalFactor ? scaleHorizontalFactor : scaleVerticalFactor;
        int newWidth = (int)Math.round((double)img.getWidth() * factor);
        int newHeight = (int)Math.round((double)img.getHeight() * factor);
        Image imgScaled = img.getScaledInstance(newWidth, newHeight, 1);
        BufferedImage imageBuf = new BufferedImage(chosenWidth, chosenHeight, 1);
        Graphics2D newImage = imageBuf.createGraphics();
        newImage.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        newImage.setBackground(this.hexToColor(bgColor));
        newImage.clearRect(0, 0, chosenWidth, chosenHeight);
        newImage.drawImage(imgScaled, this.getImageOffset(chosenWidth, newWidth), this.getImageOffset(chosenHeight, newHeight), newWidth, newHeight, null);
        return imageBuf;
    }

    public BufferedImage createScaledImage(BufferedImage img, double factor) {
        int imgWidth = img.getWidth();
        int imgHeight = img.getHeight();
        int newWidth = new Double((double)imgWidth * factor).intValue();
        int newHeight = new Double((double)imgHeight * factor).intValue();
        Image imgScaled = img.getScaledInstance(newWidth, newHeight, 1);
        BufferedImage scaledImage = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D aImage = scaledImage.createGraphics();
        aImage.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        aImage.drawImage(imgScaled, 0, 0, newWidth, newHeight, null);
        return scaledImage;
    }

    private double getScaleFactor(int chosenDim, int imgDim) {
        return (double)chosenDim / (double)imgDim;
    }

    private int getImageOffset(int newDim, int oldDim) {
        int offset = 0;
        if (newDim >= oldDim) {
            offset = (newDim - oldDim) / 2;
        }
        return offset;
    }

    private Color hexToColor(String rrggbb) {
        Color color;
        block5: {
            color = Color.WHITE;
            String hexColor = "";
            hexColor = rrggbb.startsWith("#") ? rrggbb.substring(1) : rrggbb;
            int length = hexColor.length();
            if (length == 3 || length == 6) {
                try {
                    if (length == 3) {
                        char c1 = hexColor.charAt(0);
                        char c2 = hexColor.charAt(1);
                        char c3 = hexColor.charAt(2);
                        color = Color.decode("0x" + c1 + c1 + c2 + c2 + c3 + c3);
                    } else {
                        color = Color.decode("0x" + hexColor);
                    }
                }
                catch (NumberFormatException nfe) {
                    if (!LOG.isTraceEnabled()) break block5;
                    LOG.trace((Object)("An exception occurred: " + nfe.getMessage()));
                }
            }
        }
        return color;
    }
}

