/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.persistent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.dataflow.SpoolConfig;
import org.exoplatform.services.jcr.impl.dataflow.persistent.FilePersistedValueData;
import org.exoplatform.services.jcr.impl.util.io.SpoolFile;
import org.exoplatform.services.jcr.impl.util.io.SwapFile;

public class StreamPersistedValueData
extends FilePersistedValueData {
    protected InputStream stream;
    protected SpoolFile tempFile;

    public StreamPersistedValueData(int orderNumber, InputStream stream, SpoolConfig spoolConfig) throws IOException {
        this(orderNumber, stream, (File)null, spoolConfig);
    }

    public StreamPersistedValueData(int orderNumber, SpoolFile tempFile, SpoolConfig spoolConfig) throws IOException {
        this(orderNumber, tempFile, null, spoolConfig);
    }

    public StreamPersistedValueData(int orderNumber, InputStream stream, File destFile, SpoolConfig spoolConfig) throws IOException {
        super(orderNumber, destFile, spoolConfig);
        this.tempFile = null;
        this.stream = stream;
    }

    public StreamPersistedValueData(int orderNumber, SpoolFile tempFile, File destFile, SpoolConfig spoolConfig) throws IOException {
        super(orderNumber, destFile, spoolConfig);
        this.tempFile = tempFile;
        this.stream = null;
        if (tempFile != null) {
            tempFile.acquire(this);
        }
    }

    public StreamPersistedValueData() throws IOException {
    }

    public InputStream getStream() throws IOException {
        return this.stream;
    }

    public SpoolFile getTempFile() {
        return this.tempFile;
    }

    public void setPersistedFile(File file) throws FileNotFoundException {
        if (file instanceof SwapFile) {
            ((SwapFile)file).acquire(this);
        }
        this.file = file;
        this.tempFile = null;
        this.stream = null;
    }

    public boolean isPersisted() {
        return this.file != null;
    }

    public long getLength() {
        if (this.file != null) {
            return PrivilegedFileHelper.length((File)this.file);
        }
        if (this.tempFile != null) {
            return PrivilegedFileHelper.length((File)this.tempFile);
        }
        if (this.stream instanceof FileInputStream) {
            try {
                return ((FileInputStream)this.stream).getChannel().size();
            }
            catch (IOException e) {
                return -1L;
            }
        }
        try {
            return this.stream.available();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.file instanceof SwapFile) {
                ((SwapFile)this.file).release(this);
            }
            if (this.tempFile != null) {
                this.tempFile.release(this);
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    protected boolean internalEquals(ValueData another) {
        if (another instanceof StreamPersistedValueData) {
            StreamPersistedValueData streamValue = (StreamPersistedValueData)another;
            if (this.file != null && this.file.equals(streamValue.file)) {
                return true;
            }
            if (this.tempFile != null && this.tempFile.equals(streamValue.tempFile)) {
                return true;
            }
            if (this.stream != null && this.stream == streamValue.stream) {
                return true;
            }
        }
        return false;
    }
}

