/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.container;

import java.util.Collections;
import java.util.List;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.container.UIContainerActionListener;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(template="system:/groovy/portal/webui/container/UIColumnContainer.gtmpl", events={@EventConfig(listeners={InsertColumnActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.DeleteComponentActionListener.class}, confirm="UIColumnContainer.deleteColumnContainer"), @EventConfig(listeners={UIContainerActionListener.EditContainerActionListener.class})})
public class UIColumnContainer
extends UIContainer {
    public static final String COLUMN_CONTAINER = "ColumnContainer";
    public static final String INSERT_AFTER = "insertColumnAfter";
    public static final String INSERT_BEFORE = "insertColumnBefore";

    private static void insertColumn(UIColumnContainer selectedColumn, boolean isInsertAfter) throws Exception {
        UIContainer uiParent = (UIContainer)selectedColumn.getParent();
        UIColumnContainer uiNewColumn = (UIColumnContainer)uiParent.addChild(UIColumnContainer.class, null, null);
        uiNewColumn.setTemplate(selectedColumn.getTemplate());
        uiNewColumn.setFactoryId(selectedColumn.getFactoryId());
        uiNewColumn.setId(String.valueOf(((Object)((Object)uiNewColumn)).hashCode()));
        List listColumn = uiParent.getChildren();
        int position = listColumn.indexOf((Object)selectedColumn);
        if (isInsertAfter) {
            ++position;
        }
        Collections.rotate(listColumn.subList(position, listColumn.size()), 1);
    }

    public static class InsertColumnActionListener
    extends EventListener<UIColumnContainer> {
        public void execute(Event<UIColumnContainer> event) throws Exception {
            String insertPosition = event.getRequestContext().getRequestParameter("objectId");
            UIColumnContainer uiSelectedColumn = (UIColumnContainer)((Object)event.getSource());
            UIPortalComponent uiParent = (UIPortalComponent)uiSelectedColumn.getParent();
            if (insertPosition.equals(UIColumnContainer.INSERT_AFTER)) {
                UIColumnContainer.insertColumn(uiSelectedColumn, true);
            } else if (insertPosition.equals(UIColumnContainer.INSERT_BEFORE)) {
                UIColumnContainer.insertColumn(uiSelectedColumn, false);
            }
            PortalRequestContext pcontext = (PortalRequestContext)event.getRequestContext();
            pcontext.addUIComponentToUpdateByAjax((UIComponent)uiParent);
            pcontext.ignoreAJAXUpdateOnPortlets(true);
            pcontext.getJavascriptManager().require("SHARED/portalComposer", "portalComposer").addScripts("portalComposer.toggleSaveButton();");
        }
    }
}

