/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.hierarchy.impl;

import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionManager;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionMode;
import org.exoplatform.services.jcr.ext.distribution.DataDistributionType;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.hierarchy.impl.AddPathPlugin;
import org.exoplatform.services.jcr.ext.hierarchy.impl.HierarchyConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewUserListener
extends UserEventListener {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.ext.NewUserListener");
    private final HierarchyConfig config_;
    private final RepositoryService jcrService_;
    private final NodeHierarchyCreator nodeHierarchyCreatorService_;
    private final DataDistributionType dataDistributionType_;

    public NewUserListener(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreatorService, DataDistributionManager dataDistributionManager, InitParams params) throws Exception {
        this.jcrService_ = jcrService;
        this.dataDistributionType_ = dataDistributionManager.getDataDistributionType(DataDistributionMode.NONE);
        this.config_ = (HierarchyConfig)params.getObjectParamValues(HierarchyConfig.class).get(0);
        nodeHierarchyCreatorService.addPlugin((ComponentPlugin)new AddPathPlugin(params));
        this.nodeHierarchyCreatorService_ = nodeHierarchyCreatorService;
    }

    public void preSave(User user, boolean isNew) throws Exception {
        if (isNew) {
            this.processUserStructure(this.jcrService_.getCurrentRepository(), user.getUserName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUserStructure(ManageableRepository manageableRepository, String userName) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            try {
                Node userNode = this.nodeHierarchyCreatorService_.getUserNode(sessionProvider, userName);
                List<HierarchyConfig.JcrPath> jcrPaths = this.config_.getJcrPaths();
                for (HierarchyConfig.JcrPath jcrPath : jcrPaths) {
                    this.createNode(userNode, jcrPath.getPath(), jcrPath.getNodeType(), jcrPath.getMixinTypes(), jcrPath.getPermissions(userName));
                }
                Object var9_9 = null;
                sessionProvider.close();
                sessionProvider = null;
            }
            catch (Exception e) {
                LOG.error((Object)("An error occurs while initializing the user directory of '" + userName + "'"), (Throwable)e);
                Object var9_10 = null;
                sessionProvider.close();
                sessionProvider = null;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            sessionProvider.close();
            sessionProvider = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preDelete(User user) {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            try {
                this.nodeHierarchyCreatorService_.removeUserNode(sessionProvider, user.getUserName());
            }
            catch (Exception e) {
                LOG.error((Object)("An error occurs while removing the user directory of '" + user.getUserName() + "'"), (Throwable)e);
                Object var5_4 = null;
                sessionProvider.close();
                sessionProvider = null;
            }
            Object var5_3 = null;
            sessionProvider.close();
            sessionProvider = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            sessionProvider.close();
            sessionProvider = null;
            throw throwable;
        }
    }

    private void createNode(Node userNode, String path, String nodeType, List<String> mixinTypes, Map<String, String[]> permissions) throws Exception {
        this.dataDistributionType_.getOrCreateDataNode(userNode, path, nodeType, mixinTypes, permissions);
    }
}

