/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.listeners;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;

public class SocialMembershipListenerImpl
extends MembershipEventListener {
    public void postDelete(Membership m) throws Exception {
        if (m.getGroupId().startsWith("/spaces")) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            UserACL acl = (UserACL)container.getComponentInstanceOfType(UserACL.class);
            SpaceService spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
            Space space = spaceService.getSpaceByGroupId(m.getGroupId());
            space.setEditor(ConversationState.getCurrent().getIdentity().getUserId());
            if (acl.getAdminMSType().equalsIgnoreCase(m.getMembershipType())) {
                spaceService.setManager(space, m.getUserName(), false);
                SpaceUtils.refreshNavigation();
            } else if ("member".equalsIgnoreCase(m.getMembershipType())) {
                spaceService.removeMember(space, m.getUserName());
                spaceService.setManager(space, m.getUserName(), false);
                SpaceUtils.refreshNavigation();
            }
        } else if (m.getGroupId().startsWith("/platform/users")) {
            this.clearIdentityCaching();
        }
    }

    public void postSave(Membership m, boolean isNew) throws Exception {
        if (m.getGroupId().startsWith("/spaces")) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            UserACL acl = (UserACL)container.getComponentInstanceOfType(UserACL.class);
            SpaceService spaceService = (SpaceService)container.getComponentInstanceOfType(SpaceService.class);
            Space space = spaceService.getSpaceByGroupId(m.getGroupId());
            if (space != null) {
                space.setEditor(ConversationState.getCurrent().getIdentity().getUserId());
                String userName = m.getUserName();
                if (acl.getAdminMSType().equalsIgnoreCase(m.getMembershipType())) {
                    if (spaceService.isManager(space, userName)) {
                        return;
                    }
                    if (spaceService.isMember(space, userName)) {
                        spaceService.setManager(space, userName, true);
                    } else {
                        spaceService.addMember(space, userName);
                        spaceService.setManager(space, userName, true);
                    }
                } else if ("member".equalsIgnoreCase(m.getMembershipType())) {
                    if (spaceService.isMember(space, userName)) {
                        return;
                    }
                    spaceService.addMember(space, userName);
                }
                SpaceUtils.refreshNavigation();
            }
        } else if (m.getGroupId().startsWith("/platform/users")) {
            this.clearIdentityCaching();
        }
    }

    private void clearIdentityCaching() {
        IdentityStorage storage = (IdentityStorage)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityStorage.class);
        storage.updateIdentityMembership(null);
    }
}

