/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.query.Row;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.services.cms.documents.DocumentTypeService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.wcm.search.base.LazyPageList;
import org.exoplatform.services.wcm.search.base.PageListFactory;
import org.exoplatform.services.wcm.search.base.QueryData;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class DocumentProviderUtils {
    private static final String Contents_Document_Type = "Content";
    private static final String FAVORITE_ALIAS = "userPrivateFavorites";
    private static final Log LOG = ExoLogger.getLogger((String)DocumentProviderUtils.class.getName());
    private static final String[] prohibitedSortType = new String[]{"Size", "Type", "Date"};
    private static DocumentProviderUtils docProviderUtil_ = new DocumentProviderUtils();
    private List<String> folderTypes_;

    private DocumentProviderUtils() {
    }

    public static DocumentProviderUtils getInstance() {
        return docProviderUtil_;
    }

    public boolean canSortType(String sortType) {
        for (String type : prohibitedSortType) {
            if (!type.equals(sortType)) continue;
            return false;
        }
        return true;
    }

    public LazyPageList<NodeLinkAware> getPageList(String ws, String path, Preference pref, Set<String> allItemFilter, Set<String> allItemByTypeFilter, NodeLinkAware parent) throws Exception {
        String statement;
        LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        NodeFinder nodeFinder = (NodeFinder)WCMCoreUtils.getService(NodeFinder.class);
        try {
            Node node = (Node)nodeFinder.getItem(ws, path);
            if (linkManager.isLink((Item)node)) {
                path = linkManager.getTarget(node).getPath();
            }
            statement = this.getStatement(ws, path, pref, allItemFilter, allItemByTypeFilter);
        }
        catch (Exception e) {
            statement = null;
        }
        QueryData queryData = new QueryData(statement, ws, "sql", WCMCoreUtils.getRemoteUser().equals(WCMCoreUtils.getSuperUser()));
        return PageListFactory.createLazyPageList((QueryData)queryData, (int)pref.getNodesPerPage(), (SearchDataCreator)new NodeLinkAwareCreator(parent));
    }

    private String getStatement(String ws, String path, Preference pref, Set<String> allItemsFilterSet, Set<String> allItemsByTypeFilter) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf = this.addPathParam(buf, path);
        buf = this.addJcrEnableParam(buf, ws, path, pref);
        buf = this.addShowNonDocumentType(buf, pref, allItemsByTypeFilter);
        buf = this.addShowHiddenNodeParam(buf, pref);
        buf = this.addOwnedByMeParam(buf, allItemsFilterSet);
        buf = this.addFavoriteParam(buf, ws, allItemsFilterSet);
        buf = this.addAllItemByType(buf, allItemsByTypeFilter);
        return (buf = this.addSortParam(buf, pref)) == null ? null : buf.toString();
    }

    private StringBuilder addPathParam(StringBuilder buf, String path) {
        buf.append("SELECT * FROM nt:base ");
        if (path != null) {
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            buf.append("WHERE jcr:path LIKE '").append(path).append("/%' AND NOT jcr:path LIKE '").append(path).append("/%/%' ");
        }
        return buf;
    }

    private StringBuilder addJcrEnableParam(StringBuilder buf, String ws, String path, Preference pref) throws Exception {
        TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        SessionProvider provider = WCMCoreUtils.getUserSessionProvider();
        Session session = provider.getSession(ws, WCMCoreUtils.getRepository());
        Node node = (Node)session.getItem(path);
        if (!pref.isJcrEnable() && templateService.isManagedNodeType(node.getPrimaryNodeType().getName()) && !node.isNodeType("nt:folder") && !node.isNodeType("nt:unstructured")) {
            return null;
        }
        return buf;
    }

    private StringBuilder addShowNonDocumentType(StringBuilder buf, Preference pref, Set<String> allItemsByTypeFilter) throws Exception {
        if (buf == null) {
            return null;
        }
        if (!pref.isShowNonDocumentType() || allItemsByTypeFilter.contains(Contents_Document_Type)) {
            if (this.folderTypes_ == null) {
                this.folderTypes_ = this.getFolderTypes();
            }
            buf.append(" AND (");
            buf.append("( jcr:primaryType='").append("nt:unstructured").append("') OR (exo:primaryType='").append("nt:unstructured").append("') ");
            buf.append(" OR ( jcr:primaryType='").append("nt:folder").append("') OR (exo:primaryType='").append("nt:folder").append("') ");
            for (String fType : this.folderTypes_) {
                buf.append(" OR ( jcr:primaryType='").append(fType).append("') OR (exo:primaryType='").append(fType).append("') ");
            }
            TemplateService templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
            List docTypes = templateService.getDocumentTemplates();
            for (String docType : docTypes) {
                buf.append(" OR ( jcr:primaryType='").append(docType).append("') OR (exo:primaryType='").append(docType).append("') ");
            }
            buf.append(" ) ");
        }
        return buf;
    }

    private List<String> getFolderTypes() {
        ArrayList<String> ret;
        block3: {
            ret = new ArrayList<String>();
            ExtendedNodeTypeManager nodeTypeManager = WCMCoreUtils.getRepository().getNodeTypeManager();
            try {
                NodeTypeIterator iter = nodeTypeManager.getAllNodeTypes();
                while (iter.hasNext()) {
                    NodeType type = iter.nextNodeType();
                    if (!type.isNodeType("nt:folder") && !type.isNodeType("nt:unstructured")) continue;
                    ret.add(type.getName());
                }
            }
            catch (RepositoryException e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn("Can not get all node types", new Object[]{e.getMessage()});
            }
        }
        return ret;
    }

    private StringBuilder addShowHiddenNodeParam(StringBuilder buf, Preference pref) {
        if (buf == null) {
            return null;
        }
        if (!pref.isShowHiddenNode()) {
            buf.append(" AND ( NOT jcr:mixinTypes='").append("exo:hiddenable").append("')");
        }
        return buf;
    }

    private StringBuilder addOwnedByMeParam(StringBuilder buf, Set<String> allItemsFilterSet) {
        if (buf == null) {
            return null;
        }
        if (allItemsFilterSet.contains("OwnedByMe")) {
            buf.append(" AND ( exo:owner='").append(ConversationState.getCurrent().getIdentity().getUserId()).append("')");
        }
        return buf;
    }

    private StringBuilder addFavoriteParam(StringBuilder buf, String ws, Set<String> allItemsFilterSet) throws Exception {
        if (buf == null) {
            return null;
        }
        if (allItemsFilterSet.contains("Favorites")) {
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)WCMCoreUtils.getService(NodeHierarchyCreator.class);
            Node userNode = nodeHierarchyCreator.getUserNode(WCMCoreUtils.getUserSessionProvider(), ConversationState.getCurrent().getIdentity().getUserId());
            String favoritePath = nodeHierarchyCreator.getJcrPath(FAVORITE_ALIAS);
            int count = 0;
            buf.append(" AND (");
            NodeIterator iter = userNode.getNode(favoritePath).getNodes();
            while (iter.hasNext()) {
                Node node = iter.nextNode();
                if (!node.isNodeType("exo:symlink") || !node.hasProperty("exo:workspace") || !ws.equals(node.getProperty("exo:workspace").getString())) continue;
                if (count++ > 0) {
                    buf.append(" OR ");
                }
                buf.append(" jcr:uuid='").append(node.getProperty("exo:uuid").getString()).append("'");
            }
            buf.append(" ) ");
            if (count == 0) {
                return null;
            }
        }
        return buf;
    }

    private StringBuilder addAllItemByType(StringBuilder buf, Set<String> allItemsByTypeFilterSet) {
        if (allItemsByTypeFilterSet.isEmpty()) {
            return buf;
        }
        DocumentTypeService documentTypeService = (DocumentTypeService)WCMCoreUtils.getService(DocumentTypeService.class);
        StringBuilder buf1 = new StringBuilder(" AND (");
        int count = 0;
        for (String documentType : allItemsByTypeFilterSet) {
            for (String mimeType : documentTypeService.getMimeTypes(documentType)) {
                if (count++ > 0) {
                    buf1.append(" OR ");
                }
                if (mimeType.endsWith("/")) {
                    mimeType = mimeType.substring(0, mimeType.length() - 1);
                }
                buf1.append(" 'jcr:content/jcr:mimeType' like '").append(mimeType).append("/%'");
            }
        }
        buf1.append(" )");
        if (count > 0) {
            buf.append((CharSequence)buf1);
        }
        return buf;
    }

    private StringBuilder addSortParam(StringBuilder buf, Preference pref) {
        if (buf == null) {
            return null;
        }
        String type = "";
        type = "Alphabetic".equals(pref.getSortType()) ? "exo:name" : ("CreatedDate".equals(pref.getSortType()) ? "exo:dateCreated" : ("ModifiedDate".equals(pref.getSortType()) ? "exo:lastModifiedDate" : pref.getSortType()));
        buf.append(" ORDER BY ").append(type).append(" ");
        buf.append("Ascending".equals(pref.getOrder()) ? "ASC" : "DESC");
        return buf;
    }

    public class NodeLinkAwareCreator
    implements SearchDataCreator<NodeLinkAware> {
        private NodeLinkAware parent;

        public NodeLinkAwareCreator(NodeLinkAware parent) {
            this.parent = parent;
        }

        public NodeLinkAware createData(Node node, Row row) {
            block4: {
                try {
                    return (NodeLinkAware)this.parent.getNode(StringUtils.substringAfterLast((String)node.getPath(), (String)"/"));
                }
                catch (PathNotFoundException e) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn("Can not create NodeLinkAware ", new Object[]{e.getMessage()});
                    }
                }
                catch (RepositoryException e) {
                    if (!LOG.isWarnEnabled()) break block4;
                    LOG.warn("Can not create NodeLinkAware ", new Object[]{e.getMessage()});
                }
            }
            return null;
        }
    }
}

