/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.ConstraintViolationException;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionContainer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionList;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionListContainer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionManager;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeExplorer;
import org.exoplatform.ecm.webui.form.UIDialogForm;
import org.exoplatform.ecm.webui.nodetype.selector.UINodeTypeSelector;
import org.exoplatform.ecm.webui.selector.ComponentSelector;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.url.navigation.NavigationResource;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInputBase;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfigs(value={@ComponentConfig(type=UIFormMultiValueInputSet.class, id="WYSIWYGRichTextMultipleInputset", events={@EventConfig(listeners={UIDialogForm.AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={UIFormMultiValueInputSet.RemoveActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIDialogForm.OnchangeActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowComponentActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveReferenceActionListener.class}, confirm="DialogFormField.msg.confirm-delete", phase=Event.Phase.DECODE)})})
public class UIActionForm
extends UIDialogForm
implements UISelectable {
    private String parentPath_;
    private String nodeTypeName_ = null;
    private boolean isAddNew_;
    private String scriptPath_ = null;
    private boolean isEditInList_ = false;
    private String rootPath_ = null;
    private String currentAction = null;
    private static final String EXO_ACTIONS = "exo:actions";
    private static final Log LOG = ExoLogger.getLogger((String)UIActionForm.class.getName());

    public String getDriverName() {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiExplorer.getRepositoryName() + "/" + uiExplorer.getDriveData().getName();
    }

    public UIActionForm() throws Exception {
        this.setActions(new String[]{"Save", "Back"});
    }

    public void createNewAction(Node parentNode, String actionType, boolean isAddNew) throws Exception {
        this.reset();
        this.parentPath_ = parentNode.getPath();
        this.nodeTypeName_ = actionType;
        this.isAddNew_ = isAddNew;
        this.componentSelectors.clear();
        this.properties.clear();
        this.getChildren().clear();
    }

    private Node getParentNode() throws Exception {
        return (Node)this.getSession().getItem(this.parentPath_);
    }

    public void setCurrentAction(String currentAction) {
        this.currentAction = currentAction;
    }

    public String getCurrentAction() {
        return this.currentAction;
    }

    public void doSelect(String selectField, Object value) throws Exception {
        this.isUpdateSelect = true;
        UIComponent uicomponent = this.getChildById(selectField);
        if (UIFormStringInput.class.isInstance(uicomponent)) {
            ((UIFormStringInput)uicomponent).setValue((Object)value.toString());
        } else if (UIFormMultiValueInputSet.class.isInstance(uicomponent)) {
            ((UIFormMultiValueInputSet)uicomponent).setValue((List)((ArrayList)value));
        }
        if (this.isEditInList_) {
            UIActionManager uiManager = (UIActionManager)this.getAncestorOfType(UIActionManager.class);
            UIActionListContainer uiActionListContainer = (UIActionListContainer)uiManager.getChild(UIActionListContainer.class);
            uiActionListContainer.removeChildById("PopupComponent");
        } else {
            UIActionContainer uiActionContainer = (UIActionContainer)this.getParent();
            uiActionContainer.removeChildById("PopupComponent");
        }
    }

    public String getCurrentPath() throws Exception {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode().getPath();
    }

    public ResourceResolver getTemplateResourceResolver(WebuiRequestContext context, String template) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getJCRTemplateResourceResolver();
    }

    public String getTemplate() {
        return this.getDialogPath();
    }

    public String getDialogPath() {
        String dialogPath;
        block3: {
            this.repositoryName = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            String userName = Util.getPortalRequestContext().getRemoteUser();
            dialogPath = null;
            if (this.nodeTypeName_ != null) {
                try {
                    dialogPath = templateService.getTemplatePathByUser(true, this.nodeTypeName_, userName);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
        return dialogPath;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getTemplateNodeType() {
        return this.nodeTypeName_;
    }

    private void setPath(String scriptPath) {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        if (scriptPath.indexOf(":") < 0) {
            scriptPath = uiExplorer.getCurrentWorkspace() + ":" + scriptPath;
        }
        this.scriptPath_ = scriptPath;
    }

    public String getPath() {
        return this.scriptPath_;
    }

    public void setRootPath(String rootPath) {
        this.rootPath_ = rootPath;
    }

    public String getRootPath() {
        return this.rootPath_;
    }

    public void setIsEditInList(boolean isEditInList) {
        this.isEditInList_ = isEditInList;
    }

    public void onchange(Event<?> event) throws Exception {
        if (this.isEditInList_ || !this.isAddNew_) {
            event.getRequestContext().addUIComponentToUpdateByAjax(this.getParent());
            return;
        }
        UIActionManager uiManager = (UIActionManager)this.getAncestorOfType(UIActionManager.class);
        uiManager.setRenderedChild(UIActionContainer.class);
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
    }

    public void renderField(String name) throws Exception {
        UIComponent uiInput = this.findComponentById(name);
        if ("homePath".equals(name)) {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            String homPath = uiExplorer.getCurrentWorkspace() + ":" + currentNode.getPath();
            ((UIFormStringInput)uiInput).setValue((Object)homPath);
        }
        super.renderField(name);
    }

    public static class BackActionListener
    extends EventListener<UIActionForm> {
        public void execute(Event<UIActionForm> event) throws Exception {
            UIActionForm uiForm = (UIActionForm)((Object)event.getSource());
            UIActionManager uiManager = (UIActionManager)uiForm.getAncestorOfType(UIActionManager.class);
            if (uiForm.isAddNew_) {
                uiManager.setRenderedChild(UIActionListContainer.class);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
            } else if (uiForm.isEditInList_) {
                uiForm.releaseLock();
                uiManager.setRenderedChild(UIActionListContainer.class);
                uiManager.setDefaultConfig();
                UIActionListContainer uiActionListContainer = (UIActionListContainer)uiManager.getChild(UIActionListContainer.class);
                UIPopupWindow uiPopup = (UIPopupWindow)uiActionListContainer.findComponentById("editActionPopup");
                uiPopup.setShow(false);
                uiPopup.setRendered(false);
                uiForm.isEditInList_ = false;
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
            } else {
                UIJCRExplorer uiExplorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
                uiExplorer.cancelAction();
            }
        }
    }

    public static class RemoveActionListener
    extends EventListener<UIActionForm> {
        public void execute(Event<UIActionForm> event) throws Exception {
            UIActionForm uiForm = (UIActionForm)((Object)event.getSource());
            uiForm.isRemoveActionField = true;
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class AddActionListener
    extends EventListener<UIActionForm> {
        public void execute(Event<UIActionForm> event) throws Exception {
            UIActionForm uiForm = (UIActionForm)((Object)event.getSource());
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class RemoveReferenceActionListener
    extends EventListener<UIActionForm> {
        public void execute(Event<UIActionForm> event) throws Exception {
            UIActionForm uiForm = (UIActionForm)((Object)event.getSource());
            uiForm.isRemovePreference = true;
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            UIComponent uicomponent = uiForm.getChildById(fieldName);
            if (UIFormStringInput.class.isInstance(uicomponent)) {
                ((UIFormStringInput)uicomponent).setValue(null);
            } else if (UIFormMultiValueInputSet.class.isInstance(uicomponent)) {
                ((UIFormMultiValueInputSet)uicomponent).setValue(new ArrayList());
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getParent());
        }
    }

    public static class ShowComponentActionListener
    extends EventListener<UIActionForm> {
        public void execute(Event<UIActionForm> event) throws Exception {
            String[] stringArray;
            UIJCRExplorer explorer;
            UIActionForm uiForm = (UIActionForm)((Object)event.getSource());
            UIContainer uiContainer = null;
            uiForm.isShowingComponent = true;
            uiContainer = uiForm.isEditInList_ ? (UIContainer)uiForm.getAncestorOfType(UIActionListContainer.class) : (UIContainer)uiForm.getParent();
            String fieldName = event.getRequestContext().getRequestParameter("objectId");
            Map fieldPropertiesMap = (Map)uiForm.componentSelectors.get(fieldName);
            String classPath = (String)fieldPropertiesMap.get("selectorClass");
            String rootPath = (String)fieldPropertiesMap.get("rootPath");
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(classPath, true, cl);
            UIComponent uiComp = uiContainer.createUIComponent(clazz, null, null);
            String selectorParams = (String)fieldPropertiesMap.get("selectorParams");
            if (uiComp instanceof UIOneNodePathSelector) {
                String[] arrParams;
                explorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
                String repositoryName = explorer.getRepositoryName();
                SessionProvider provider = explorer.getSessionProvider();
                String wsFieldName = (String)fieldPropertiesMap.get("workspaceField");
                String wsName = explorer.getCurrentWorkspace();
                if (wsFieldName != null && wsFieldName.length() > 0) {
                    wsName = (String)((UIFormInputBase)uiForm.getUIInput(wsFieldName)).getValue();
                    ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, true);
                }
                if (selectorParams != null && (arrParams = selectorParams.split(",")).length == 4) {
                    ((UIOneNodePathSelector)uiComp).setAcceptedNodeTypesInPathPanel(new String[]{"nt:file"});
                    wsName = arrParams[1];
                    rootPath = arrParams[2];
                    ((UIOneNodePathSelector)uiComp).setIsDisable(wsName, true);
                    if (arrParams[3].indexOf(";") > -1) {
                        ((UIOneNodePathSelector)uiComp).setAcceptedMimeTypes(arrParams[3].split(";"));
                    } else {
                        ((UIOneNodePathSelector)uiComp).setAcceptedMimeTypes(new String[]{arrParams[3]});
                    }
                }
                if (rootPath == null) {
                    rootPath = "/";
                }
                ((UIOneNodePathSelector)uiComp).setRootNodeLocation(repositoryName, wsName, rootPath);
                ((UIOneNodePathSelector)uiComp).setShowRootPathSelect(true);
                ((UIOneNodePathSelector)uiComp).init(provider);
            } else if (uiComp instanceof UINodeTypeSelector) {
                explorer = (UIJCRExplorer)uiForm.getAncestorOfType(UIJCRExplorer.class);
                ((UINodeTypeSelector)uiComp).setRepositoryName(explorer.getRepositoryName());
                UIFormMultiValueInputSet uiFormMultiValueInputSet = (UIFormMultiValueInputSet)uiForm.getChildById(fieldName);
                List values = uiFormMultiValueInputSet.getValue();
                ((UINodeTypeSelector)uiComp).init(1, values);
            }
            if (uiForm.isEditInList_) {
                ((UIActionListContainer)uiContainer).initPopup(uiComp);
            } else {
                ((UIActionContainer)uiContainer).initPopup(uiComp);
            }
            String param = "returnField=" + fieldName;
            if (selectorParams == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = param;
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = param;
                stringArray = stringArray3;
                stringArray3[1] = "selectorParams=" + selectorParams;
            }
            String[] params = stringArray;
            ((ComponentSelector)uiComp).setSourceComponent((UIComponent)uiForm, params);
            if (uiForm.isAddNew_) {
                UIContainer uiParent = (UIContainer)uiContainer.getParent();
                uiParent.setRenderedChild(uiContainer.getId());
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiContainer);
        }
    }

    public static class SaveActionListener
    extends EventListener<UIActionForm> {
        private void addInputInfo(Map<String, JcrInputProperty> input, UIActionForm actionForm) throws Exception {
            String rssUrlKey = "/node/exo:url";
            if (input.get(rssUrlKey) == null) {
                return;
            }
            UIJCRExplorer uiExplorer = (UIJCRExplorer)actionForm.getAncestorOfType(UIJCRExplorer.class);
            UITreeExplorer treeExplorer = (UITreeExplorer)uiExplorer.findFirstComponentOfType(UITreeExplorer.class);
            String driveName = treeExplorer.getDriveName();
            PortalRequestContext pContext = Util.getPortalRequestContext();
            NodeURL nodeURL = (NodeURL)pContext.createURL(NodeURL.TYPE);
            NavigationResource resource = new NavigationResource(Util.getUIPortal().getSelectedUserNode());
            nodeURL.setResource(resource);
            nodeURL.setQueryParameterValue("path", driveName);
            nodeURL.setSchemeUse(true);
            input.get(rssUrlKey).setValue((Object)nodeURL.toString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UIActionForm> event) throws Exception {
            String[] arrFilterChar;
            String targetPath;
            String targetPath2;
            UIActionForm actionForm = (UIActionForm)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)actionForm.getAncestorOfType(UIApplication.class);
            ActionServiceContainer actionServiceContainer = (ActionServiceContainer)actionForm.getApplicationComponent(ActionServiceContainer.class);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)actionForm.getAncestorOfType(UIJCRExplorer.class);
            String repository = ((UIJCRExplorer)actionForm.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
            Map sortedInputs = DialogFormUtil.prepareMap((List)actionForm.getChildren(), (Map)actionForm.getInputProperties(), (Map)actionForm.getInputOptions());
            this.addInputInfo(sortedInputs, actionForm);
            Node currentNode = uiExplorer.getCurrentNode();
            if (!PermissionUtil.canAddNode((Node)currentNode) || !PermissionUtil.canSetProperty((Node)currentNode)) {
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.no-permission-add", null));
                return;
            }
            UIFormStringInput homePathInput = actionForm.getUIStringInput("homePath");
            if (homePathInput != null && ((targetPath2 = (String)homePathInput.getValue()) == null || targetPath2.length() == 0)) {
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.homePath-emty", null, 1));
                return;
            }
            UIFormStringInput targetPathInput = actionForm.getUIStringInput("targetPath");
            if (targetPathInput != null && ((targetPath = (String)targetPathInput.getValue()) == null || targetPath.length() == 0)) {
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.targetPath-emty", null, 1));
                return;
            }
            String actionName = (String)((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue();
            for (String filterChar : arrFilterChar = new String[]{"&", "$", "@", ":", "]", "[", "*", "%", "!", "+", "(", ")", "'", "#", ";", "}", "{", "/", "|", "\""}) {
                if (actionName.indexOf(filterChar) <= -1) continue;
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.name-not-allowed", null, 1));
                return;
            }
            Node parentNode = actionForm.getParentNode();
            if (actionForm.isAddNew_) {
                if (parentNode.hasNode(UIActionForm.EXO_ACTIONS) && parentNode.getNode(UIActionForm.EXO_ACTIONS).hasNode(actionName)) {
                    Object[] args = new Object[]{actionName};
                    uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.existed-action", args, 1));
                    return;
                }
            } else if (actionForm.isEditInList_ && parentNode.hasNode(UIActionForm.EXO_ACTIONS) && parentNode.getNode(UIActionForm.EXO_ACTIONS).hasNode(actionName) && !actionName.equals(actionForm.currentAction)) {
                Object[] args = new Object[]{actionName};
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.existed-action", args, 1));
                return;
            }
            try {
                JcrInputProperty rootProp;
                if (uiExplorer.nodeIsLocked(currentNode)) {
                    return;
                }
                if (!actionForm.isAddNew_) {
                    CmsService cmsService = (CmsService)actionForm.getApplicationComponent(CmsService.class);
                    Node storedHomeNode = actionForm.getNode().getParent();
                    Node currentActionNode = storedHomeNode.getNode(((JcrInputProperty)sortedInputs.get("/node")).getValue().toString());
                    if (uiExplorer.nodeIsLocked(currentActionNode)) {
                        return;
                    }
                    cmsService.storeNode(actionForm.nodeTypeName_, storedHomeNode, sortedInputs, false);
                    Session session = currentActionNode.getSession();
                    if (uiExplorer.nodeIsLocked(currentActionNode)) {
                        return;
                    }
                    session.move(currentActionNode.getPath(), storedHomeNode.getPath() + "/" + ((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue().toString());
                    session.save();
                    currentNode.getSession().save();
                    if (actionForm.isEditInList_) {
                        UIActionManager uiManager = (UIActionManager)actionForm.getAncestorOfType(UIActionManager.class);
                        UIPopupWindow uiPopup = (UIPopupWindow)uiManager.findComponentById("editActionPopup");
                        uiPopup.setShow(false);
                        uiPopup.setRendered(false);
                        uiManager.setDefaultConfig();
                        actionForm.isEditInList_ = false;
                        actionForm.setIsOnchange(false);
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
                        uiExplorer.setIsHidePopup(true);
                        uiExplorer.updateAjax(event);
                    } else {
                        uiExplorer.setIsHidePopup(false);
                        uiExplorer.updateAjax(event);
                    }
                    actionForm.setPath(storedHomeNode.getPath());
                    actionServiceContainer.removeAction(currentNode, currentActionNode.getName(), repository);
                }
                if ((rootProp = (JcrInputProperty)sortedInputs.get("/node")) == null) {
                    rootProp = new JcrInputProperty();
                    rootProp.setJcrPath("/node");
                    rootProp.setValue(((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue());
                    sortedInputs.put("/node", rootProp);
                } else {
                    rootProp.setValue(((JcrInputProperty)sortedInputs.get("/node/exo:name")).getValue());
                }
                if (parentNode.isNew()) {
                    Object[] args = new String[]{parentNode.getPath()};
                    uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.unable-add-action", args));
                    return;
                }
                actionServiceContainer.addAction(parentNode, actionForm.nodeTypeName_, sortedInputs);
                actionForm.setIsOnchange(false);
                parentNode.getSession().save();
                UIActionManager uiActionManager = (UIActionManager)actionForm.getAncestorOfType(UIActionManager.class);
                actionForm.createNewAction(uiExplorer.getCurrentNode(), actionForm.nodeTypeName_, true);
                UIActionList uiActionList = (UIActionList)uiActionManager.findFirstComponentOfType(UIActionList.class);
                uiActionList.updateGrid(parentNode, ((UIPageIterator)uiActionList.getChild(UIPageIterator.class)).getCurrentPage());
                uiActionManager.setRenderedChild(UIActionListContainer.class);
                actionForm.reset();
            }
            catch (ConstraintViolationException cex) {
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.constraintviolation-exception", null, 1));
                return;
            }
            catch (RepositoryException repo) {
                String key = "UIActionForm.msg.repository-exception";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                return;
            }
            catch (NumberFormatException nume) {
                String key = "UIActionForm.msg.numberformat-exception";
                uiApp.addMessage(new ApplicationMessage(key, null, 1));
                return;
            }
            catch (NullPointerException nullPointerException) {
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.unable-add", null, 1));
                return;
            }
            catch (NoSuchFieldException ns) {
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.lifecycle-invalid", null, 1));
                return;
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UIActionForm.msg.unable-add", null, 1));
                return;
            }
            finally {
                if (actionForm.isEditInList_) {
                    actionForm.releaseLock();
                    actionForm.isEditInList_ = false;
                }
            }
        }
    }
}

