/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model;

import java.text.DateFormat;
import java.util.Date;
import net.fortuna.ical4j.model.CalendarDateFormatFactory;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.util.Dates;

public abstract class Iso8601
extends Date {
    private DateFormat format;
    private DateFormat gmtFormat;
    private int precision;

    public Iso8601(long time, String pattern, int precision) {
        super(Dates.round(time, precision));
        this.format = CalendarDateFormatFactory.getInstance(pattern);
        this.precision = precision;
    }

    public Iso8601(String pattern, int precision) {
        this(System.currentTimeMillis(), pattern, precision);
    }

    public Iso8601(Date time, String pattern, int precision) {
        this(time.getTime(), pattern, precision);
    }

    public String toString() {
        if (!(this.format.getTimeZone() instanceof TimeZone)) {
            if (this.gmtFormat == null) {
                this.gmtFormat = (DateFormat)this.format.clone();
                this.gmtFormat.setTimeZone(TimeZone.getTimeZone("Etc/GMT"));
            }
            if (this.format.getTimeZone().inDaylightTime(this) && this.format.getTimeZone().inDaylightTime(new Date(this.getTime() - 1L))) {
                return this.gmtFormat.format(new Date(this.getTime() + (long)this.format.getTimeZone().getRawOffset() + (long)this.format.getTimeZone().getDSTSavings()));
            }
            return this.gmtFormat.format(new Date(this.getTime() + (long)this.format.getTimeZone().getRawOffset()));
        }
        return this.format.format(this);
    }

    protected final DateFormat getFormat() {
        return this.format;
    }

    public void setTime(long time) {
        super.setTime(Dates.round(time, this.precision, this.format.getTimeZone()));
    }
}

