/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity.plugin;

import org.exoplatform.social.common.ResourceBundleUtil;
import org.exoplatform.social.core.application.RelationshipPublisher;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.webui.Utils;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.lifecycle.WebuiBindingContext;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/activity/plugin/UIRelationshipActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.LoadLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}), @EventConfig(listeners={AcceptActionListener.class}), @EventConfig(listeners={RefuseActionListener.class}), @EventConfig(listeners={RevokeActionListener.class})})
public class UIRelationshipActivity
extends BaseUIActivity {
    private RelationshipPublisher.TitleId titleId;
    private String senderName;
    private String receiverName;
    private String relationshipUUID;
    private Relationship relationship;
    private Identity sender;
    private Identity receiver;
    private Relationship.Type status;

    public void setTitleId(RelationshipPublisher.TitleId titleId) {
        this.titleId = titleId;
    }

    public RelationshipPublisher.TitleId getTitleId() {
        return this.titleId;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    public String getSenderName() {
        return this.senderName;
    }

    public void setReceiverName(String receiverName) {
        this.receiverName = receiverName;
    }

    public String getReceiverName() {
        return this.receiverName;
    }

    public void setSender(Identity sender) {
        this.sender = sender;
    }

    public Identity getSender() {
        if (this.sender == null) {
            this.sender = Utils.getIdentityManager().getOrCreateIdentity("organization", this.senderName, false);
        }
        return this.sender;
    }

    public void setReceiver(Identity receiver) {
        this.receiver = receiver;
    }

    public Identity getReceiver() {
        if (this.receiver == null) {
            this.receiver = Utils.getIdentityManager().getOrCreateIdentity("organization", this.receiverName, false);
        }
        return this.receiver;
    }

    public void setStatus(Relationship.Type status) {
        this.status = status;
    }

    public Relationship.Type getStatus() throws Exception {
        if (this.status == null) {
            this.status = Utils.getRelationshipManager().getStatus(this.getSender(), this.getReceiver());
        }
        return this.status;
    }

    public void setRelationship(Relationship relationship) {
        this.relationship = relationship;
    }

    public Relationship getRelationship() throws Exception {
        if (this.relationship == null) {
            this.relationship = Utils.getRelationshipManager().get(this.relationshipUUID);
        }
        return this.relationship;
    }

    public boolean isActivityStreamOwner() {
        UIActivitiesContainer uiActivititesContainer = (UIActivitiesContainer)this.getAncestorOfType(UIActivitiesContainer.class);
        return Utils.getViewerRemoteId().equals(uiActivititesContainer.getOwnerName());
    }

    public boolean isSender() throws Exception {
        return Utils.getViewerRemoteId().equals(this.senderName);
    }

    public boolean isReceiver() throws Exception {
        return Utils.getViewerRemoteId().equals(this.receiverName);
    }

    public String getActivityTitle(WebuiBindingContext ctx) throws Exception {
        UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getAncestorOfType(UIUserActivitiesDisplay.class);
        if (uiUserActivitiesDisplay == null) {
            return null;
        }
        UIUserActivitiesDisplay.DisplayMode displayMode = uiUserActivitiesDisplay.getSelectedDisplayMode();
        String senderLink = LinkProvider.getProfileLink((String)this.senderName);
        String receiverLink = LinkProvider.getProfileLink((String)this.receiverName);
        if (this.titleId == RelationshipPublisher.TitleId.CONNECTION_CONFIRMED) {
            if (this.isActivityStreamOwner() && displayMode == UIUserActivitiesDisplay.DisplayMode.MY_ACTIVITIES || Utils.getViewerRemoteId().equals(this.getOwnerIdentity().getRemoteId())) {
                if (this.isSender()) {
                    return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.You_Are_Now_Connected_With_UserName"), (String[])new String[]{receiverLink});
                }
                return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.You_Are_Now_Connected_With_UserName"), (String[])new String[]{senderLink});
            }
            return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.UserName_Are_Now_Connected_With_UserName"), (String[])new String[]{receiverLink, senderLink});
        }
        if (this.titleId == RelationshipPublisher.TitleId.CONNECTION_REQUESTED) {
            if (this.isActivityStreamOwner() && displayMode == UIUserActivitiesDisplay.DisplayMode.MY_ACTIVITIES) {
                if (this.isSender()) {
                    return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.You_Invited_UserName_To_Connect"), (String[])new String[]{receiverLink});
                }
                return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.UserName_Invited_You_To_Connect"), (String[])new String[]{senderLink});
            }
            if (Utils.getViewerRemoteId().equals(this.getOwnerIdentity().getRemoteId())) {
                if (this.isSender()) {
                    return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.You_Invited_UserName_To_Connect"), (String[])new String[]{receiverLink});
                }
                return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.UserName_Invited_You_To_Connect"), (String[])new String[]{senderLink});
            }
            if (this.isReceiver()) {
                return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.UserName_Invited_UserName_To_Connect"), (String[])new String[]{senderLink, receiverLink});
            }
            return ResourceBundleUtil.replaceArguments((String)ctx.appRes("UIRelationshipActivity.msg.UserName_Invited_UserName_To_Connect"), (String[])new String[]{senderLink, receiverLink});
        }
        return "";
    }

    public void setRelationshipUUID(String relationshipUUID) {
        this.relationshipUUID = relationshipUUID;
    }

    public String getRelationshipUUID() {
        return this.relationshipUUID;
    }

    public static class RevokeActionListener
    extends EventListener<UIRelationshipActivity> {
        public void execute(Event<UIRelationshipActivity> event) throws Exception {
        }
    }

    public static class RefuseActionListener
    extends EventListener<UIRelationshipActivity> {
        public void execute(Event<UIRelationshipActivity> event) throws Exception {
            UIRelationshipActivity uiRelationshipActivity = (UIRelationshipActivity)((Object)event.getSource());
            Relationship relationship = uiRelationshipActivity.getRelationship();
            if (relationship != null && relationship.getStatus() == Relationship.Type.PENDING) {
                Utils.getRelationshipManager().deny(relationship);
                Utils.updateWorkingWorkSpace();
            }
        }
    }

    public static class AcceptActionListener
    extends EventListener<UIRelationshipActivity> {
        public void execute(Event<UIRelationshipActivity> event) throws Exception {
            UIRelationshipActivity uiRelationshipActivity = (UIRelationshipActivity)((Object)event.getSource());
            Relationship relationship = uiRelationshipActivity.getRelationship();
            if (relationship != null && relationship.getStatus() == Relationship.Type.PENDING) {
                Utils.getRelationshipManager().confirm(relationship);
                Utils.updateWorkingWorkSpace();
            }
        }
    }
}

