/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.common.service.thread;

import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.exoplatform.social.common.service.thread.ThreadPoolConfig;
import org.exoplatform.social.common.service.thread.ThreadPoolFactory;

public class DefaultThreadPoolFactory
implements ThreadPoolFactory {
    @Override
    public ExecutorService newCachedThreadPool(ThreadFactory threadFactory) {
        return Executors.newCachedThreadPool(threadFactory);
    }

    @Override
    public ExecutorService newThreadPool(ThreadPoolConfig config, ThreadFactory factory) {
        return this.newThreadPool(config.getPoolSize(), config.getMaxPoolSize(), config.getKeepAliveTime(), config.getTimeUnit(), config.getMaxQueueSize(), factory);
    }

    public ExecutorService newThreadPool(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, int maxQueueSize, ThreadFactory threadFactory) throws IllegalArgumentException {
        AbstractQueue workQueue;
        if (corePoolSize < 1) {
            throw new IllegalArgumentException("CorePoolSize must be >= 1, was " + corePoolSize);
        }
        if (maxPoolSize < corePoolSize) {
            throw new IllegalArgumentException("MaxPoolSize must be >= corePoolSize, was " + maxPoolSize + " >= " + corePoolSize);
        }
        if (corePoolSize == 0 && maxQueueSize <= 0) {
            workQueue = new SynchronousQueue();
            corePoolSize = 1;
            maxPoolSize = 1;
        } else {
            workQueue = maxQueueSize <= 0 ? new SynchronousQueue() : new LinkedBlockingQueue(maxQueueSize);
        }
        ThreadPoolExecutor answer = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, (BlockingQueue<Runnable>)((Object)workQueue));
        answer.setThreadFactory(threadFactory);
        answer.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        return answer;
    }

    @Override
    public ScheduledExecutorService newScheduledThreadPool(ThreadPoolConfig config, ThreadFactory threadFactory) {
        return new ScheduledThreadPoolExecutor(config.getPoolSize(), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
    }
}

