/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.sanitization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class InternalLinksUpgradePlugin
extends UpgradeProductPlugin {
    private RepositoryService repoService_;
    private static final Log LOG = ExoLogger.getLogger((String)InternalLinksUpgradePlugin.class.getName());

    public InternalLinksUpgradePlugin(RepositoryService repoService, InitParams initParams) {
        super(initParams);
        this.repoService_ = repoService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        this.migrateJCRDataContents();
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }

    private void migrateJCRDataContents() {
        block16: {
            try {
                Session session = WCMCoreUtils.getSystemSessionProvider().getSession("collaboration", this.repoService_.getCurrentRepository());
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"=====Start migrate old links from jcr data====");
                }
                ArrayList<String> documentMixinTypes = new ArrayList<String>();
                HashSet<String> nodesToRepublish = new HashSet<String>();
                documentMixinTypes.add("exo:jsFile");
                documentMixinTypes.add("exo:htmlFile");
                documentMixinTypes.add("exo:cssFile");
                for (String type : documentMixinTypes) {
                    StringBuilder statement = new StringBuilder().append("select * from ").append(type).append(" ORDER BY exo:name DESC ");
                    QueryResult result = session.getWorkspace().getQueryManager().createQuery(statement.toString(), "sql").execute();
                    NodeIterator nodeIter = result.getNodes();
                    while (nodeIter.hasNext()) {
                        try {
                            String jcrData;
                            String mimeType;
                            Node content;
                            Node node = nodeIter.nextNode();
                            if (!node.hasNode("jcr:content") || !(content = node.getNode("jcr:content")).hasProperty("jcr:mimeType") || !(mimeType = content.getProperty("jcr:mimeType").getString()).startsWith("text") || !(jcrData = content.getProperty("jcr:data").getString()).contains("/sites content/live/") && !jcrData.contains("/sites%20content/live/")) continue;
                            LOG.info((Object)("=====Migrating data contents '" + content.getParent().getPath() + "' ====="));
                            String newData = StringUtils.replaceEachRepeatedly((String)jcrData, (String[])new String[]{"/sites content/live/", "/sites%20content/live/"}, (String[])new String[]{"/sites/", "/sites/"});
                            content.setProperty("jcr:data", newData);
                            session.save();
                            Node parent = node.getParent();
                            if (parent.isNodeType("exo:webContent")) {
                                nodesToRepublish.add(parent.getPath());
                                continue;
                            }
                            if (parent.getPath().equals("/")) {
                                nodesToRepublish.add(node.getPath());
                                continue;
                            }
                            Node grandParent = parent.getParent();
                            if (grandParent.isNodeType("exo:webContent")) {
                                nodesToRepublish.add(grandParent.getPath());
                                continue;
                            }
                            if (grandParent.getPath().equals("/")) {
                                nodesToRepublish.add(node.getPath());
                                continue;
                            }
                            Node ancestor = grandParent.getParent();
                            if (ancestor.isNodeType("exo:webContent")) {
                                nodesToRepublish.add(ancestor.getPath());
                                continue;
                            }
                            nodesToRepublish.add(node.getPath());
                        }
                        catch (Exception e) {
                            LOG.error((Object)"An unexpected error occurs when migrating JCR Data Content: ", (Throwable)e);
                        }
                    }
                }
                for (String nodePath : nodesToRepublish) {
                    try {
                        this.republishNode((Node)session.getItem(nodePath));
                    }
                    catch (Exception e) {
                        LOG.error((Object)"An unexpected error occurs when republishing content: ", (Throwable)e);
                    }
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"===== Migrate data in contents completed =====");
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block16;
                LOG.error((Object)"An unexpected error occurs when migrating JCR Data Contents: ", (Throwable)e);
            }
        }
    }

    private void republishNode(Node checkedNode) throws Exception {
        PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
        if (publicationService.isNodeEnrolledInLifecycle(checkedNode) && "published".equalsIgnoreCase(publicationService.getCurrentState(checkedNode))) {
            HashMap context = new HashMap();
            LOG.info((Object)("=====Republish '" + checkedNode.getPath() + "' ====="));
            publicationService.changeState(checkedNode, "draft", context);
            publicationService.changeState(checkedNode, "published", context);
        }
    }
}

