/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form;

import java.io.Writer;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIFormInputBase;

public class UIFormHiddenInput
extends UIFormInputBase<String> {
    public UIFormHiddenInput(String name, String bindingExpression, String value) {
        super(name, bindingExpression, String.class);
        this.value_ = value;
    }

    public UIFormHiddenInput(String name, String value) {
        this(name, null, value);
    }

    @Override
    public void decode(Object input, WebuiRequestContext context) {
        this.value_ = (String)input;
        if (this.value_ != null && ((String)this.value_).length() == 0) {
            this.value_ = null;
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        w.write("<input name='");
        w.write(this.getName());
        w.write("'  type='hidden'");
        w.write(" id='");
        w.write(this.getId());
        w.write("'");
        String value = (String)this.getValue();
        if (value != null && value.length() > 0) {
            w.write(" value='");
            value = HTMLEntityEncoder.getInstance().encodeHTMLAttribute(value);
            w.write(value);
            w.write("'");
        }
        this.renderHTMLAttributes(w);
        w.write(" />");
    }
}

