/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.folksonomy;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class TagsUpgradePlugin
extends UpgradeProductPlugin {
    public static final String PUBLIC_TAG_NODE_PATH = "exoPublicTagNode";
    public static final String COLLABORATION = "collaboration";
    private NewFolksonomyService folksonomyService_;
    private NodeHierarchyCreator nodeCreator_;
    private LinkManager linkManager_;
    private static final Log log = ExoLogger.getLogger((String)TagsUpgradePlugin.class.getName());

    public TagsUpgradePlugin(NewFolksonomyService folksonomyService, NodeHierarchyCreator nodeCreator, LinkManager linkManager, InitParams initParams) {
        super(initParams);
        this.folksonomyService_ = folksonomyService;
        this.nodeCreator_ = nodeCreator;
        this.linkManager_ = linkManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpgrade(String oldVersion, String newVersion) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
        SessionProvider sessionProvider = null;
        try {
            sessionProvider = SessionProvider.createSystemProvider();
            Session session = sessionProvider.getSession(COLLABORATION, WCMCoreUtils.getRepository());
            Node tempFolder = session.getRootNode().addNode("temp");
            session.save();
            String publicTagNodePath = this.nodeCreator_.getJcrPath(PUBLIC_TAG_NODE_PATH);
            NodeIterator oldTagIter = ((Node)session.getItem(publicTagNodePath)).getNodes();
            while (oldTagIter.hasNext()) {
                Node oldTag = oldTagIter.nextNode();
                try {
                    String tagName = oldTag.getName();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Migrating tag '" + tagName + "'..."));
                    }
                    session.move(oldTag.getPath(), tempFolder.getPath() + '/' + tagName);
                    session.save();
                    NodeIterator iter = tempFolder.getNode(tagName).getNodes();
                    while (iter.hasNext()) {
                        Node link = iter.nextNode();
                        if (!this.linkManager_.isLink((Item)link)) continue;
                        Node targetDoc = this.linkManager_.getTarget(link, true);
                        this.folksonomyService_.addPublicTag(publicTagNodePath, new String[]{tagName}, targetDoc, COLLABORATION);
                    }
                    tempFolder.getNode(tagName).remove();
                    session.save();
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Can not migrate tag '" + oldTag.getName() + "': "), (Throwable)e);
                }
            }
            tempFolder.remove();
            session.save();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"An unexpected error occurs when migrating tags: ", (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Finish " + ((Object)((Object)this)).getClass().getName() + "............."));
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

