/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.templates;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.QueryManager;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.version.util.VersionComparator;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.views.ApplicationTemplateManagerService;
import org.exoplatform.services.cms.views.impl.ApplicationTemplateManagerServiceImpl;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WCMTemplateUpgradePlugin
extends UpgradeProductPlugin {
    private static final Log log = ExoLogger.getLogger((String)WCMTemplateUpgradePlugin.class.getName());
    private ApplicationTemplateManagerService appTemplateService_;

    public WCMTemplateUpgradePlugin(ApplicationTemplateManagerService appTemplateService, InitParams initParams) {
        super(initParams);
        this.appTemplateService_ = appTemplateService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        block3: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Start " + ((Object)((Object)this)).getClass().getName() + "............."));
            }
            String unchangedClvTemplates = PrivilegedSystemHelper.getProperty((String)"unchanged-clv-templates");
            String unchangedSearchTemplates = PrivilegedSystemHelper.getProperty((String)"unchanged-wcm-search-templates");
            this.upgrade(unchangedClvTemplates, "content-list-viewer");
            this.upgrade(unchangedSearchTemplates, "search");
            try {
                ((ApplicationTemplateManagerServiceImpl)this.appTemplateService_).start();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"An unexpected error occurs when migrating templates for portlet CLV and WCMSearch: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgrade(String unchangedTemplates, String portletName) {
        SessionProvider sessionProvider = null;
        if (StringUtils.isEmpty((String)unchangedTemplates)) {
            unchangedTemplates = "";
        }
        try {
            HashSet<String> unchangedTemplateSet = new HashSet<String>();
            Set configuredTemplates = this.appTemplateService_.getConfiguredAppTemplateMap(portletName);
            ArrayList<Node> removedNodes = new ArrayList<Node>();
            for (String unchangedTemplate : unchangedTemplates.split(",")) {
                unchangedTemplateSet.add(unchangedTemplate.trim());
            }
            sessionProvider = SessionProvider.createSystemProvider();
            Node templateHomeNode = this.appTemplateService_.getApplicationTemplateHome(portletName, sessionProvider);
            QueryManager queryManager = templateHomeNode.getSession().getWorkspace().getQueryManager();
            NodeIterator iter = queryManager.createQuery("SELECT * FROM nt:file WHERE jcr:path LIKE '" + templateHomeNode.getPath() + "/%'", "sql").execute().getNodes();
            while (iter.hasNext()) {
                Node templateNode = iter.nextNode();
                if (unchangedTemplateSet.contains(templateNode.getPath().substring(templateHomeNode.getPath().length() + 1)) || !configuredTemplates.contains(templateNode.getPath().substring(templateHomeNode.getPath().length() + 1))) continue;
                removedNodes.add(templateNode);
            }
            for (Node removedNode : removedNodes) {
                try {
                    String editedTemplate = removedNode.getParent().getName().concat(removedNode.getName());
                    removedNode.remove();
                    templateHomeNode.save();
                    Utils.removeEditedConfiguredData((String)editedTemplate, (String)ApplicationTemplateManagerServiceImpl.class.getSimpleName(), (String)"EditedConfiguredTemplates", (boolean)true);
                }
                catch (Exception e) {
                    if (!log.isInfoEnabled()) continue;
                    log.error((Object)("Error in " + this.getName() + ": Can not remove old template: " + removedNode.getPath()));
                }
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("An unexpected error occurs when migrating templates for portlet: " + portletName + ": "), (Throwable)e);
            }
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    public boolean shouldProceedToUpgrade(String newVersion, String previousVersion) {
        return VersionComparator.isAfter((String)newVersion, (String)previousVersion);
    }
}

