/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class GenreBox
extends AbstractFullBox {
    public static final String TYPE = "gnre";
    private String language;
    private String genre;

    public GenreBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getGenre() {
        return this.genre;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setGenre(String genre) {
        this.genre = genre;
    }

    protected long getContentSize() {
        return 2 + GenreBox.utf8StringLengthInBytes(this.genre) + 1;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.language = in.readIso639();
        this.genre = in.readString();
    }

    public String toString() {
        return "GenreBox[language=" + this.getLanguage() + ";genre=" + this.getGenre() + "]";
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeIso639(this.language);
        os.writeStringZeroTerm(this.genre);
    }
}

