/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.boxes.mp4.objectdescriptors;

import com.coremedia.iso.Hex;
import com.coremedia.iso.IsoBufferWrapper;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.BaseDescriptor;
import java.io.IOException;
import java.util.logging.Logger;

public class UnknownDescriptor
extends BaseDescriptor {
    private static Logger log = Logger.getLogger(UnknownDescriptor.class.getName());

    public void parse(int tag, IsoBufferWrapper in, int maxLength) throws IOException {
        super.parse(tag, in, maxLength);
        long remaining = in.remaining();
        if (remaining < (long)this.getSize()) {
            log.warning("Wrong size parsed! size: " + this.getSize() + ", remaining: " + remaining + " for " + this);
            this.setData(in.read((int)remaining));
        } else {
            this.setData(in.read(this.getSize()));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UnknownDescriptor");
        sb.append("{tag=").append(this.tag);
        sb.append(", sizeOfInstance=").append(this.sizeOfInstance);
        sb.append(", data=").append(this.data == null ? "null" : Hex.encodeHex(this.data));
        sb.append('}');
        return sb.toString();
    }
}

